/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpRequestMessage;
import org.jetlinks.core.message.codec.http.HttpUtils;
import org.jetlinks.core.message.codec.http.MultiPart;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

@Generated
public class DefaultHttpRequestMessage
implements HttpRequestMessage {
    private ByteBuf payload;
    private String url;
    private HttpMethod method;
    private List<Header> headers = new ArrayList<Header>();
    private Map<String, String> queryParameters = new HashMap<String, String>();
    private MediaType contentType;
    private MultiPart multiPart;

    public Optional<MultiPart> multiPart() {
        return Optional.ofNullable(this.multiPart).filter(part -> part.getParts().size() > 0);
    }

    public void setBody(Object body) {
        if (body instanceof ByteBuf) {
            this.setPayload((ByteBuf)body);
        } else if (body instanceof String) {
            this.setPayload(Unpooled.wrappedBuffer((byte[])((String)body).getBytes()));
        } else if (body instanceof byte[]) {
            this.setPayload(Unpooled.wrappedBuffer((byte[])((byte[])body)));
        } else if (MediaType.APPLICATION_JSON.includes(this.getContentType())) {
            this.setPayload(Unpooled.wrappedBuffer((byte[])JSON.toJSONBytes((Object)body, (SerializerFeature[])new SerializerFeature[0])));
        } else if (MediaType.APPLICATION_FORM_URLENCODED.includes(this.getContentType()) && body instanceof Map) {
            this.setPayload(Unpooled.wrappedBuffer((byte[])HttpUtils.createEncodedUrlParams((Map)((Map)body)).getBytes()));
        } else if (body != null) {
            this.setPayload(Unpooled.wrappedBuffer((byte[])JSON.toJSONBytes((Object)body, (SerializerFeature[])new SerializerFeature[0])));
        } else {
            this.setPayload(Unpooled.EMPTY_BUFFER);
        }
    }

    public String toString() {
        return this.print();
    }

    public ByteBuf getPayload() {
        return this.payload;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public MultiPart getMultiPart() {
        return this.multiPart;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setContentType(MediaType contentType) {
        this.contentType = contentType;
    }

    public void setMultiPart(MultiPart multiPart) {
        this.multiPart = multiPart;
    }

    public DefaultHttpRequestMessage(ByteBuf payload, String url, HttpMethod method, List<Header> headers, Map<String, String> queryParameters, MediaType contentType, MultiPart multiPart) {
        this.payload = payload;
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.queryParameters = queryParameters;
        this.contentType = contentType;
        this.multiPart = multiPart;
    }

    public DefaultHttpRequestMessage() {
    }
}

