/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.device.service.LocalDeviceProductService;
import org.jetlinks.community.device.spi.DeviceConfigMetadataSupplier;
import org.jetlinks.community.gateway.supports.DeviceGatewayPropertiesManager;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.ConfigScope;
import org.jetlinks.core.metadata.DeviceConfigScope;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.Feature;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DefaultDeviceConfigMetadataSupplier
implements DeviceConfigMetadataSupplier {
    private final LocalDeviceInstanceService instanceService;
    private final LocalDeviceProductService productService;
    private final ProtocolSupports protocolSupports;
    private final DeviceGatewayPropertiesManager gatewayPropertiesManager;

    @Override
    public Flux<ConfigMetadata> getDeviceConfigMetadata(String deviceId) {
        if (StringUtils.isEmpty((Object)deviceId)) {
            return Flux.empty();
        }
        return ((ReactiveQuery)((ReactiveQuery)this.instanceService.createQuery().select(new StaticMethodReferenceColumn[]{DeviceInstanceEntity::getProductId})).where(DeviceInstanceEntity::getId, (Object)deviceId)).fetchOne().map(DeviceInstanceEntity::getProductId).flatMapMany(this::getProductConfigMetadata0).filter(metadata -> metadata.hasScope((ConfigScope)DeviceConfigScope.device));
    }

    @Override
    public Flux<ConfigMetadata> getDeviceConfigMetadataByProductId(String productId) {
        if (StringUtils.isEmpty((Object)productId)) {
            return Flux.empty();
        }
        return this.getProductConfigMetadata0(productId).filter(metadata -> metadata.hasScope((ConfigScope)DeviceConfigScope.device));
    }

    @Override
    public Flux<ConfigMetadata> getProductConfigMetadata(String productId) {
        if (StringUtils.isEmpty((Object)productId)) {
            return Flux.empty();
        }
        return this.getProductConfigMetadata0(productId).filter(metadata -> metadata.hasScope((ConfigScope)DeviceConfigScope.product));
    }

    @Override
    public Flux<ConfigMetadata> getMetadataExpandsConfig(String productId, DeviceMetadataType metadataType, String metadataId, String typeId) {
        Assert.hasText((String)productId, (String)"message.productId_cannot_be_empty");
        Assert.notNull((Object)metadataType, (String)"message.metadataType_cannot_be_empty");
        return this.computeDeviceProtocol(productId, (protocol, transport) -> protocol.getMetadataExpandsConfig(transport, metadataType, metadataId, typeId)).flatMapMany(Function.identity());
    }

    @Override
    public Flux<ConfigMetadata> getProductConfigMetadataByAccessId(String productId, String accessId) {
        return this.gatewayPropertiesManager.getProperties(accessId).flatMapMany(properties -> this.protocolSupports.getProtocol(properties.getProtocol()).onErrorMap(e -> new BusinessException("error.unable_to_load_protocol_by_access_id", 404, new Object[]{properties.getProtocol()})).flatMap(support -> support.getConfigMetadata(Transport.of((String)properties.getTransport()))));
    }

    private Flux<ConfigMetadata> getProductConfigMetadata0(String productId) {
        return this.productService.findById(productId).filter(product -> StringUtils.hasText((String)product.getMessageProtocol())).flatMapMany(product -> this.protocolSupports.getProtocol(product.getMessageProtocol()).onErrorMap(e -> new BusinessException("error.unable_to_load_protocol_by_access_id", 404, new Object[]{product.getMessageProtocol()})).flatMap(support -> support.getConfigMetadata(Transport.of((String)product.getTransportProtocol()))));
    }

    @Override
    public Flux<Feature> getProductFeatures(String productId) {
        Assert.hasText((String)productId, (String)"message.productId_cannot_be_empty");
        return this.computeDeviceProtocol(productId, ProtocolSupport::getFeatures).flatMapMany(Function.identity());
    }

    protected <T> Mono<T> computeDeviceProtocol(String productId, BiFunction<ProtocolSupport, Transport, T> computer) {
        return ((ReactiveQuery)((ReactiveQuery)this.productService.createQuery().select(new StaticMethodReferenceColumn[]{DeviceProductEntity::getMessageProtocol, DeviceProductEntity::getTransportProtocol})).where(DeviceInstanceEntity::getId, (Object)productId)).fetchOne().flatMap(product -> Mono.zip((Mono)Mono.justOrEmpty((Object)product.getMessageProtocol()).flatMap(arg_0 -> ((ProtocolSupports)this.protocolSupports).getProtocol(arg_0)).onErrorMap(e -> new BusinessException("error.unable_to_load_protocol_by_access_id", 404, new Object[]{product.getMessageProtocol()})), (Mono)Mono.justOrEmpty((Object)product.getTransportProtocol()).map(Transport::of), (BiFunction)computer));
    }

    public DefaultDeviceConfigMetadataSupplier(LocalDeviceInstanceService instanceService, LocalDeviceProductService productService, ProtocolSupports protocolSupports, DeviceGatewayPropertiesManager gatewayPropertiesManager) {
        this.instanceService = instanceService;
        this.productService = productService;
        this.protocolSupports = protocolSupports;
        this.gatewayPropertiesManager = gatewayPropertiesManager;
    }
}

