/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements.status;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.jetlinks.community.Interval;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.MeasurementValue;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.device.timeseries.DeviceTimeSeriesMetric;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.timeseries.TimeSeriesService;
import org.jetlinks.community.timeseries.query.AggregationQueryParam;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DeviceStatusChangeMeasurement
extends StaticMeasurement {
    private final EventBus eventBus;
    private final TimeSeriesManager timeSeriesManager;
    static MeasurementDefinition definition = MeasurementDefinition.of((String)"change", (String)"\u8bbe\u5907\u72b6\u6001\u53d8\u66f4");
    static ConfigMetadata configMetadata = new DefaultConfigMetadata().add("deviceId", "\u8bbe\u5907", "\u6307\u5b9a\u8bbe\u5907", (DataType)new StringType().expand("selector", (Object)"device-selector"));
    static DataType type = new EnumType().addElement(EnumType.Element.of((String)MessageType.OFFLINE.name().toLowerCase(), (String)"\u79bb\u7ebf")).addElement(EnumType.Element.of((String)MessageType.ONLINE.name().toLowerCase(), (String)"\u5728\u7ebf"));
    static ConfigMetadata historyConfigMetadata = new DefaultConfigMetadata().add("time", "\u5468\u671f", "\u4f8b\u5982: 1h,10m,30s", (DataType)new StringType()).add("format", "\u65f6\u95f4\u683c\u5f0f", "\u5982: MM-dd:HH", (DataType)new StringType()).add("type", "\u7c7b\u578b", "\u4e0a\u7ebfor\u79bb\u7ebf", (DataType)new EnumType().addElement(EnumType.Element.of((String)"online", (String)"\u4e0a\u7ebf")).addElement(EnumType.Element.of((String)"offline", (String)"\u79bb\u7ebf"))).add("limit", "\u6700\u5927\u6570\u636e\u91cf", "", (DataType)new IntType()).add("from", "\u65f6\u95f4\u4ece", "", (DataType)new DateTimeType()).add("to", "\u65f6\u95f4\u81f3", "", (DataType)new DateTimeType());
    static DataType historyValueType = new IntType();

    public DeviceStatusChangeMeasurement(TimeSeriesManager timeSeriesManager, EventBus eventBus) {
        super(definition);
        this.eventBus = eventBus;
        this.timeSeriesManager = timeSeriesManager;
        this.addDimension(new RealTimeDeviceStateDimension());
        this.addDimension(new CountDeviceStateDimension());
    }

    class RealTimeDeviceStateDimension
    implements MeasurementDimension {
        RealTimeDeviceStateDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.realTime;
        }

        public DataType getValueType() {
            return type;
        }

        public ConfigMetadata getParams() {
            return configMetadata;
        }

        public boolean isRealTime() {
            return true;
        }

        public Flux<MeasurementValue> getValue(MeasurementParameter parameter) {
            return Mono.justOrEmpty((Optional)parameter.getString("deviceId")).flatMapMany(deviceId -> DeviceStatusChangeMeasurement.this.eventBus.subscribe(Subscription.of((String)"RealTimeDeviceStateDimension", (String[])new String[]{"/device/*/" + deviceId + "/online", "/device/*/" + deviceId + "/offline"}, (Subscription.Feature[])new Subscription.Feature[]{Subscription.Feature.local, Subscription.Feature.broker}), DeviceMessage.class).map(msg -> SimpleMeasurementValue.of(this.createStateValue((DeviceMessage)msg), (long)msg.getTimestamp())));
        }

        Map<String, Object> createStateValue(DeviceMessage message) {
            HashMap<String, Object> val = new HashMap<String, Object>();
            val.put("type", message.getMessageType().name().toLowerCase());
            val.put("deviceId", message.getDeviceId());
            return val;
        }
    }

    class CountDeviceStateDimension
    implements MeasurementDimension {
        CountDeviceStateDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.agg;
        }

        public DataType getValueType() {
            return historyValueType;
        }

        public ConfigMetadata getParams() {
            return historyConfigMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public Flux<SimpleMeasurementValue> getValue(MeasurementParameter parameter) {
            String format = parameter.getString("format").orElse("yyyy\u5e74MM\u6708dd\u65e5");
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
            return ((Flux)AggregationQueryParam.of().sum("count").groupBy(parameter.getInterval("time", Interval.ofDays((int)1)), format).filter(query -> {
                Query cfr_ignored_0 = (Query)((Query)query.where("name", (Object)parameter.getString("type").orElse("online"))).is("productId", parameter.getString("productId").orElse(null));
            }).limit(parameter.getInt("limit").orElse(1).intValue()).from(parameter.getDate("from").orElse(Date.from(LocalDateTime.now().plusDays(-1L).atZone(ZoneId.systemDefault()).toInstant()))).to(parameter.getDate("to").orElse(new Date())).execute(arg_0 -> ((TimeSeriesService)DeviceStatusChangeMeasurement.this.timeSeriesManager.getService(DeviceTimeSeriesMetric.deviceMetrics())).aggregation(arg_0))).map(data -> {
                long ts = data.getString("time").map(time -> DateTime.parse((String)time, (DateTimeFormatter)formatter).getMillis()).orElse(System.currentTimeMillis());
                return SimpleMeasurementValue.of((Object)data.get("count").orElse(0), (String)data.getString("time", ""), (long)ts);
            }).sort();
        }
    }
}

