/*
 * Decompiled with CFR 0.152.
 */
package net.zstong.awump.base.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import net.zstong.awump.base.entity.AwInstitutionEntity;
import net.zstong.awump.base.entity.AwInstitutionInfo;
import net.zstong.awump.base.entity.AwRegionEntity;
import net.zstong.awump.base.service.AwInstitutionService;
import net.zstong.awump.base.service.AwRegionService;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/aw/base/institution"})
@Resource(id="aw-base-institution", name="\u5355\u4f4d\u7ba1\u7406\u63a5\u53e3")
@Tag(name="\u5355\u4f4d\u7ba1\u7406\u63a5\u53e3")
public class AwInstitutionController
implements ReactiveServiceCrudController<AwInstitutionEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(AwInstitutionController.class);
    @Autowired
    private AwInstitutionService awInstitutionService;
    @Autowired
    private AwRegionService awRegionService;

    public ReactiveCrudService<AwInstitutionEntity, String> getService() {
        return this.awInstitutionService;
    }

    @GetMapping(value={"/_query"})
    @QueryAction
    @QueryOperation(summary="\u4f7f\u7528GET\u65b9\u5f0f\u5206\u9875\u52a8\u6001\u67e5\u8be2(Override)")
    public Mono<PagerResult<AwInstitutionEntity>> queryPager(@Parameter(hidden=true) QueryParamEntity query) {
        return query.getTotal() != null ? ((ReactiveQuery)this.getService().createQuery().setParam(query.rePaging(query.getTotal().intValue()))).fetch().collectList().map(list -> {
            System.out.println("============queryPager=============" + list);
            return PagerResult.of((int)query.getTotal(), (List)list, (QueryParam)query);
        }) : this.getService().queryPager(query);
    }

    @PostMapping(value={"/info/_query"})
    @QueryAction
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u5355\u4f4d\u53ca\u76f8\u5173\u4fe1\u606f\u8be6\u60c5")
    public Mono<PagerResult<AwInstitutionInfo>> queryInstitution(@RequestBody Mono<QueryParamEntity> paramBody) {
        return paramBody.flatMap(param -> this.awInstitutionService.queryPager((QueryParamEntity)param).flatMap(result -> Flux.fromIterable((Iterable)result.getData()).flatMap(tp2 -> this.convert((AwInstitutionEntity)((Object)((Object)((Object)tp2))))).collectList().map(info -> PagerResult.of((int)result.getTotal(), (List)info, (QueryParam)param))));
    }

    private Mono<AwInstitutionInfo> convert(AwInstitutionEntity entity) {
        return this.awRegionService.findById(entity.getRegionId()).defaultIfEmpty((Object)new AwRegionEntity()).map(a -> {
            AwInstitutionInfo awInstitutionInfo = AwInstitutionInfo.of(entity);
            awInstitutionInfo.setRegion((AwRegionEntity)((Object)a));
            return awInstitutionInfo;
        }).flatMap(i -> this.awRegionService.findById(i.getRegion().getParentId()).defaultIfEmpty((Object)new AwRegionEntity()).map(b -> {
            i.setCity((AwRegionEntity)((Object)((Object)b)));
            return i;
        })).flatMap(j -> this.awRegionService.findById(j.getCity().getParentId()).defaultIfEmpty((Object)new AwRegionEntity()).map(c -> {
            j.setProvince((AwRegionEntity)((Object)((Object)c)));
            return j;
        }));
    }

    @GetMapping(value={"/_all/tree"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u533a\u57df\u5355\u4f4d\u4fe1\u606f(\u6811\u7ed3\u6784)")
    public Flux<AwRegionEntity> getAllOrgTree() {
        return this.awInstitutionService.getAllRegionInstitutionTree();
    }
}

