package net.zstong.awump.base.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
* @author yuanhc
* @date 2023-06-06
*/
@Getter
@Setter
@Table(name="aw_intensive_frame")
@Comment("密集架信息")
@EnableEntityEvent
public class AwIntensiveFrameEntity extends BaseEntity<String>{



    /** 所属库房 */
    @Schema(description = "所属库房")
    @Column(name = "warehouse_id_",length =64 )
    private String warehouseId;


    /** 设备编码 */
    @Schema(description = "设备编码")
    @Column(name = "code_",length =64 )
    private String code;


    /** 设备名称 */
    @Schema(description = "设备名称")
    @Column(name = "name_",nullable = false,length =256 )
    @NotBlank(message = "设备名称不能为空", groups = CreateGroup.class)
    private String name;


    /** 存储类别（库、区） */
    @Schema(description = "存储类别（库、区）")
    @Column(name = "storage_type_",length =64 )
    private String storageType;


    /** 连接地址 */
    @Schema(description = "连接地址")
    @Column(name = "link_address_",length =32 )
    private String linkAddress;


    /** 品牌 */
    @Schema(description = "品牌")
    @Column(name = "brand_",length =200 )
    private String brand;


    /** 列 */
    @Schema(description = "列")
    @Column(name = "cols_",length =32 )
    private String cols;


    /** 层 */
    @Schema(description = "层")
    @Column(name = "layers_",length =32 )
    private String layers;


    /** 组 */
    @Schema(description = "组")
    @Column(name = "groups_",length =32 )
    private String groups;


    /** 负责人 */
    @Schema(description = "负责人")
    @Column(name = "custodian_",length =32 )
    private String custodian;


    /** 负责人联系方式 */
    @Schema(description = "负责人联系方式")
    @Column(name = "phone_",length =32 )
    private String phone;


    /** 设备图片 */
    @Schema(description = "设备图片")
    @Column(name = "img_",length =256 )
    private String img;


    /** 出厂日期 */
    @Schema(description = "出厂日期")
    @Column(name = "manufacture_date_")
     @JsonFormat(pattern="yyyy-MM-dd")
     private LocalDate manufactureDate;











}