/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official.udp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import lombok.NonNull;
import org.jetlinks.core.message.AcknowledgeDeviceMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.DisconnectDeviceMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.FromDeviceMessageContext;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.protocol.official.binary.AckCode;
import org.jetlinks.protocol.official.binary.BinaryAcknowledgeDeviceMessage;
import org.jetlinks.protocol.official.binary.BinaryMessageType;
import org.jetlinks.protocol.official.binary.DataType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class UDPDeviceMessageCodec
implements DeviceMessageCodec {
    public static final String CONFIG_KEY_SECURE_KEY = "secureKey";
    public static final DefaultConfigMetadata udpConfig = new DefaultConfigMetadata("UDP\u8ba4\u8bc1\u914d\u7f6e", "").add("secureKey", "secureKey", "\u5bc6\u94a5", (org.jetlinks.core.metadata.DataType)new PasswordType());

    public Transport getSupportTransport() {
        return DefaultTransport.UDP;
    }

    @NonNull
    public Publisher<? extends Message> decode(@NonNull MessageDecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        ByteBuf payload = context.getMessage().getPayload();
        byte authType = payload.readByte();
        String token = (String)DataType.STRING.read(payload);
        DeviceMessage message = BinaryMessageType.read(payload);
        return context.getDevice(message.getDeviceId()).flatMap(device -> device.getConfig(CONFIG_KEY_SECURE_KEY).flatMap(config -> {
            if (Objects.equals(config.asString(), token)) {
                return this.ack(message, AckCode.ok, context).thenReturn((Object)message);
            }
            return Mono.empty();
        })).switchIfEmpty(Mono.defer(() -> this.ack(message, AckCode.noAuth, context)));
    }

    public static ByteBuf wrapByteByf(ByteBuf payload) {
        return payload;
    }

    private <T> Mono<T> ack(DeviceMessage source, AckCode code, MessageDecodeContext context) {
        AcknowledgeDeviceMessage message = new AcknowledgeDeviceMessage();
        message.addHeader(BinaryAcknowledgeDeviceMessage.codeHeader, (Object)code.name());
        message.setDeviceId(source.getDeviceId());
        message.setMessageId(source.getMessageId());
        message.setCode(code.name());
        message.setSuccess(code == AckCode.ok);
        source.getHeader(BinaryMessageType.HEADER_MSG_SEQ).ifPresent(seq -> {
            AcknowledgeDeviceMessage cfr_ignored_0 = (AcknowledgeDeviceMessage)message.addHeader(BinaryMessageType.HEADER_MSG_SEQ, seq);
        });
        return ((FromDeviceMessageContext)context).getSession().send(this.doEncode((DeviceMessage)message, "")).then(Mono.fromRunnable(() -> {
            if (source instanceof DeviceOnlineMessage && code != AckCode.ok) {
                ((FromDeviceMessageContext)context).getSession().close();
            }
        }));
    }

    @NonNull
    public Publisher<? extends EncodedMessage> encode(@NonNull MessageEncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        DeviceMessage deviceMessage = (DeviceMessage)context.getMessage();
        if (deviceMessage instanceof DisconnectDeviceMessage) {
            return Mono.empty();
        }
        return context.getDevice(deviceMessage.getDeviceId()).flatMap(device -> device.getConfig(CONFIG_KEY_SECURE_KEY).map(config -> this.doEncode(deviceMessage, config.asString())));
    }

    private EncodedMessage doEncode(DeviceMessage message, String token) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(0);
        DataType.STRING.write(buf, token);
        return EncodedMessage.simple((ByteBuf)UDPDeviceMessageCodec.wrapByteByf(BinaryMessageType.write(message, buf)));
    }
}

