/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official.binary;

import com.google.common.cache.CacheBuilder;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetlinks.core.device.DeviceThingType;
import org.jetlinks.core.message.AcknowledgeDeviceMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.protocol.official.binary.BinaryAcknowledgeDeviceMessage;
import org.jetlinks.protocol.official.binary.BinaryDeviceOnlineMessage;
import org.jetlinks.protocol.official.binary.BinaryEventMessage;
import org.jetlinks.protocol.official.binary.BinaryFunctionInvokeMessage;
import org.jetlinks.protocol.official.binary.BinaryFunctionInvokeMessageReply;
import org.jetlinks.protocol.official.binary.BinaryMessage;
import org.jetlinks.protocol.official.binary.BinaryReadPropertyMessage;
import org.jetlinks.protocol.official.binary.BinaryReadPropertyMessageReply;
import org.jetlinks.protocol.official.binary.BinaryReportPropertyMessage;
import org.jetlinks.protocol.official.binary.BinaryWritePropertyMessage;
import org.jetlinks.protocol.official.binary.BinaryWritePropertyMessageReply;
import org.jetlinks.protocol.official.binary.DataType;

public enum BinaryMessageType {
    keepalive(null, null),
    online(DeviceOnlineMessage.class, BinaryDeviceOnlineMessage::new),
    ack(AcknowledgeDeviceMessage.class, BinaryAcknowledgeDeviceMessage::new),
    reportProperty(ReportPropertyMessage.class, BinaryReportPropertyMessage::new),
    readProperty(ReadPropertyMessage.class, BinaryReadPropertyMessage::new),
    readPropertyReply(ReadPropertyMessageReply.class, BinaryReadPropertyMessageReply::new),
    writeProperty(WritePropertyMessage.class, BinaryWritePropertyMessage::new),
    writePropertyReply(WritePropertyMessageReply.class, BinaryWritePropertyMessageReply::new),
    function(FunctionInvokeMessage.class, BinaryFunctionInvokeMessage::new),
    functionReply(FunctionInvokeMessageReply.class, BinaryFunctionInvokeMessageReply::new),
    event(EventMessage.class, BinaryEventMessage::new);

    private final Class<? extends DeviceMessage> forDevice;
    private final Supplier<BinaryMessage<DeviceMessage>> forTcp;
    private static final BinaryMessageType[] VALUES;
    public static final HeaderKey<Integer> HEADER_MSG_SEQ;
    private static final Map<String, MsgIdHolder> cache;

    private BinaryMessageType(Class<? extends DeviceMessage> forDevice, Supplier<? extends BinaryMessage<?>> forTcp) {
        this.forDevice = forDevice;
        this.forTcp = forTcp;
    }

    private static MsgIdHolder takeHolder(String deviceId) {
        return cache.computeIfAbsent(deviceId, ignore -> new MsgIdHolder());
    }

    public static ByteBuf write(DeviceMessage message, ByteBuf data) {
        int msgId = (Integer)message.getHeaderOrElse(HEADER_MSG_SEQ, () -> BinaryMessageType.takeHolder(message.getDeviceId()).next(message.getMessageId()));
        return BinaryMessageType.write(message, msgId, data);
    }

    public static ByteBuf write(BinaryMessageType type, ByteBuf data) {
        data.writeByte(type.ordinal());
        data.writeLong(System.currentTimeMillis());
        return data;
    }

    public static ByteBuf write(DeviceMessage message, int msgId, ByteBuf data) {
        BinaryMessageType type = BinaryMessageType.lookup(message);
        data.writeByte(type.ordinal());
        data.writeLong(message.getTimestamp());
        data.writeShort(msgId);
        DataType.STRING.write(data, message.getDeviceId());
        BinaryMessage<DeviceMessage> tcp = type.forTcp.get();
        tcp.setMessage(message);
        tcp.write(data);
        return data;
    }

    public static DeviceMessage read(ByteBuf data) {
        return BinaryMessageType.read(data, null);
    }

    public static <T> T read(ByteBuf data, String deviceIdMaybe, BiFunction<DeviceMessage, Integer, T> handler) {
        BinaryMessageType type = VALUES[data.readByte()];
        if (type.forTcp == null) {
            return null;
        }
        long timestamp = data.readLong();
        int msgId = data.readUnsignedShort();
        String deviceId = (String)DataType.STRING.read(data);
        if (deviceId == null) {
            deviceId = deviceIdMaybe;
        }
        BinaryMessage<DeviceMessage> tcp = type.forTcp.get();
        tcp.read(data);
        DeviceMessage message = tcp.getMessage();
        message.thingId((ThingType)DeviceThingType.device, deviceId);
        if (timestamp > 0L) {
            message.timestamp(timestamp);
        }
        message.addHeader(HEADER_MSG_SEQ, (Object)msgId);
        return handler.apply(message, msgId);
    }

    public static DeviceMessage read(ByteBuf data, String deviceIdMaybe) {
        return BinaryMessageType.read(data, deviceIdMaybe, (message, msgId) -> {
            MsgIdHolder holder;
            String messageId = null;
            if (message.getDeviceId() != null && (holder = cache.get(message.getDeviceId())) != null) {
                messageId = holder.getAndRemove((int)msgId);
            }
            if (messageId == null && msgId > 0) {
                messageId = String.valueOf(msgId);
            }
            message.messageId(messageId);
            return message;
        });
    }

    public static BinaryMessageType lookup(DeviceMessage message) {
        for (BinaryMessageType value : VALUES) {
            if (value.forDevice == null || !value.forDevice.isInstance(message)) continue;
            return value;
        }
        throw new UnsupportedOperationException("unsupported device message " + message.getMessageType());
    }

    public static void main(String[] args) {
        System.out.println("| Byte | Type |");
        System.out.println("|  ----  | ----  |");
        for (BinaryMessageType value : BinaryMessageType.values()) {
            System.out.print("|");
            System.out.print("0x0" + Integer.toString(value.ordinal(), 16));
            System.out.print("|");
            System.out.print(value.name());
            System.out.print("|");
            System.out.println();
        }
        System.out.println();
    }

    static {
        VALUES = BinaryMessageType.values();
        HEADER_MSG_SEQ = HeaderKey.of((String)"_seq", (Object)0, Integer.class);
        cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofHours(1L)).build().asMap();
    }

    private static class MsgIdHolder {
        private int msgId = 0;
        private final Map<Integer, String> cached = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(30L)).build().asMap();

        private MsgIdHolder() {
        }

        public int next(String id) {
            if (id == null) {
                return -1;
            }
            do {
                if (this.msgId++ >= 0) continue;
                this.msgId = 0;
            } while (this.cached.putIfAbsent(this.msgId, id) != null);
            return this.msgId;
        }

        public String getAndRemove(int id) {
            if (id < 0) {
                return null;
            }
            return this.cached.remove(id);
        }
    }
}

