/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official.binary;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionParameter;
import org.jetlinks.protocol.official.binary.BinaryMessage;
import org.jetlinks.protocol.official.binary.BinaryMessageType;
import org.jetlinks.protocol.official.binary.DataType;

public class BinaryFunctionInvokeMessage
implements BinaryMessage<FunctionInvokeMessage> {
    private FunctionInvokeMessage message;

    @Override
    public BinaryMessageType getType() {
        return BinaryMessageType.function;
    }

    @Override
    public void read(ByteBuf buf) {
        this.message = new FunctionInvokeMessage();
        this.message.setFunctionId((String)DataType.STRING.read(buf));
        Map params = (Map)DataType.OBJECT.read(buf);
        this.message.setInputs(params.entrySet().stream().map(e -> new FunctionParameter((String)e.getKey(), e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public void write(ByteBuf buf) {
        DataType.STRING.write(buf, this.message.getFunctionId());
        DataType.OBJECT.write(buf, this.message.inputsToMap());
    }

    @Override
    public void setMessage(FunctionInvokeMessage message) {
        this.message = message;
    }

    @Override
    public FunctionInvokeMessage getMessage() {
        return this.message;
    }
}

