/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official.binary;

import io.netty.buffer.ByteBuf;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.protocol.official.binary.BinaryMessage;
import org.jetlinks.protocol.official.binary.BinaryMessageType;
import org.jetlinks.protocol.official.binary.DataType;

public class BinaryEventMessage
implements BinaryMessage<EventMessage> {
    private EventMessage message;

    @Override
    public BinaryMessageType getType() {
        return BinaryMessageType.event;
    }

    @Override
    public void read(ByteBuf buf) {
        this.message = new EventMessage();
        this.message.setEvent((String)DataType.STRING.read(buf));
        this.message.setData(DataType.OBJECT.read(buf));
    }

    @Override
    public void write(ByteBuf buf) {
        DataType.STRING.write(buf, this.message.getEvent());
        DataType.OBJECT.write(buf, this.message.getData());
    }

    @Override
    public void setMessage(EventMessage message) {
        this.message = message;
    }

    @Override
    public EventMessage getMessage() {
        return this.message;
    }

    public BinaryEventMessage(EventMessage message) {
        this.message = message;
    }

    public BinaryEventMessage() {
    }
}

