/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetlinks.core.defaults.Authenticator;
import org.jetlinks.core.defaults.CompositeProtocolSupport;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadataCodec;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.core.route.HttpRoute;
import org.jetlinks.core.spi.ProtocolSupportProvider;
import org.jetlinks.core.spi.ServiceContext;
import org.jetlinks.protocol.official.JetLinksAuthenticator;
import org.jetlinks.protocol.official.JetLinksCoapDeviceMessageCodec;
import org.jetlinks.protocol.official.JetLinksMqttDeviceMessageCodec;
import org.jetlinks.protocol.official.TopicMessageCodec;
import org.jetlinks.protocol.official.http.JetLinksHttpDeviceMessageCodec;
import org.jetlinks.protocol.official.tcp.TcpDeviceMessageCodec;
import org.jetlinks.protocol.official.udp.UDPDeviceMessageCodec;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public class JetLinksProtocolSupportProvider
implements ProtocolSupportProvider {
    private static final DefaultConfigMetadata mqttConfig = new DefaultConfigMetadata("MQTT\u8ba4\u8bc1\u914d\u7f6e", "MQTT\u8ba4\u8bc1\u65f6\u9700\u8981\u7684\u914d\u7f6e,mqtt\u7528\u6237\u540d,\u5bc6\u7801\u7b97\u6cd5:\nusername=secureId|timestamp\npassword=md5(secureId|timestamp|secureKey)\n\ntimestamp\u4e3a\u65f6\u95f4\u6233,\u4e0e\u670d\u52a1\u65f6\u95f4\u4e0d\u80fd\u76f8\u5dee5\u5206\u949f").add("secureId", "secureId", "\u5bc6\u94a5ID", (DataType)new StringType()).add("secureKey", "secureKey", "\u5bc6\u94a5KEY", (DataType)new PasswordType());

    public Mono<CompositeProtocolSupport> create(ServiceContext context) {
        return Mono.defer(() -> {
            CompositeProtocolSupport support = new CompositeProtocolSupport();
            support.setId("jetlinks.v3.0");
            support.setName("JetLinks V3.0");
            support.setDescription("JetLinks Protocol Version 3.0");
            support.addRoutes((Transport)DefaultTransport.MQTT, (Collection)Arrays.stream(TopicMessageCodec.values()).map(TopicMessageCodec::getRoute).filter(Objects::nonNull).collect(Collectors.toList()));
            support.setDocument((Transport)DefaultTransport.MQTT, "document-mqtt.md", JetLinksProtocolSupportProvider.class.getClassLoader());
            support.addRoutes((Transport)DefaultTransport.HTTP, (Collection)Stream.of(TopicMessageCodec.reportProperty, TopicMessageCodec.event, TopicMessageCodec.online, TopicMessageCodec.offline).map(TopicMessageCodec::getRoute).filter(route -> route != null && route.isUpstream()).map(route -> HttpRoute.builder().address(route.getTopic()).group(route.getGroup()).contentType(new MediaType[]{MediaType.APPLICATION_JSON}).method(new HttpMethod[]{HttpMethod.POST}).description(route.getDescription()).example(route.getExample()).build()).collect(Collectors.toList()));
            support.setDocument((Transport)DefaultTransport.HTTP, "document-http.md", JetLinksProtocolSupportProvider.class.getClassLoader());
            support.addAuthenticator((Transport)DefaultTransport.MQTT, (Authenticator)new JetLinksAuthenticator());
            support.setMetadataCodec((DeviceMetadataCodec)new JetLinksDeviceMetadataCodec());
            support.addConfigMetadata((Transport)DefaultTransport.MQTT, (ConfigMetadata)mqttConfig);
            support.addConfigMetadata((Transport)DefaultTransport.TCP, (ConfigMetadata)TcpDeviceMessageCodec.tcpConfig);
            support.addMessageCodecSupport((DeviceMessageCodec)new TcpDeviceMessageCodec());
            support.setDocument((Transport)DefaultTransport.TCP, "document-tcp.md", JetLinksProtocolSupportProvider.class.getClassLoader());
            support.addConfigMetadata((Transport)DefaultTransport.UDP, (ConfigMetadata)UDPDeviceMessageCodec.udpConfig);
            support.addMessageCodecSupport((DeviceMessageCodec)new UDPDeviceMessageCodec());
            support.addMessageCodecSupport((DeviceMessageCodec)new JetLinksMqttDeviceMessageCodec());
            support.addConfigMetadata((Transport)DefaultTransport.HTTP, (ConfigMetadata)JetLinksHttpDeviceMessageCodec.httpConfig);
            support.addMessageCodecSupport((DeviceMessageCodec)new JetLinksHttpDeviceMessageCodec());
            support.addConfigMetadata((Transport)DefaultTransport.CoAP, (ConfigMetadata)JetLinksCoapDeviceMessageCodec.coapConfig);
            support.addMessageCodecSupport((DeviceMessageCodec)new JetLinksCoapDeviceMessageCodec());
            return Mono.just((Object)support);
        });
    }
}

