/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DisconnectDeviceMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.FromDeviceMessageContext;
import org.jetlinks.core.message.codec.MessageCodecContext;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.MessagePayloadType;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.SimpleMqttMessage;
import org.jetlinks.core.message.codec.ToDeviceMessageContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.protocol.official.FunctionalTopicHandlers;
import org.jetlinks.protocol.official.ObjectMappers;
import org.jetlinks.protocol.official.TopicMessageCodec;
import org.jetlinks.protocol.official.TopicPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JetLinksMqttDeviceMessageCodec
implements DeviceMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(JetLinksMqttDeviceMessageCodec.class);
    private final Transport transport;
    private final ObjectMapper mapper;

    public JetLinksMqttDeviceMessageCodec(Transport transport) {
        this.transport = transport;
        this.mapper = ObjectMappers.JSON_MAPPER;
    }

    public JetLinksMqttDeviceMessageCodec() {
        this((Transport)DefaultTransport.MQTT);
    }

    public Transport getSupportTransport() {
        return this.transport;
    }

    @Nonnull
    public Mono<MqttMessage> encode(@Nonnull MessageEncodeContext context) {
        return Mono.defer(() -> {
            Message message = context.getMessage();
            if (message instanceof DisconnectDeviceMessage) {
                return ((ToDeviceMessageContext)context).disconnect().then(Mono.empty());
            }
            if (message instanceof DeviceMessage) {
                DeviceMessage deviceMessage = (DeviceMessage)message;
                TopicPayload convertResult = TopicMessageCodec.encode(this.mapper, deviceMessage);
                if (convertResult == null) {
                    return Mono.empty();
                }
                return Mono.justOrEmpty(deviceMessage.getHeader("productId").map(String::valueOf)).switchIfEmpty(context.getDevice(deviceMessage.getDeviceId()).flatMap(device -> device.getSelfConfig((ConfigKey)DeviceConfigKey.productId))).defaultIfEmpty((Object)"null").map(productId -> SimpleMqttMessage.builder().clientId(deviceMessage.getDeviceId()).topic("/".concat((String)productId).concat(convertResult.getTopic())).payloadType(MessagePayloadType.JSON).payload(Unpooled.wrappedBuffer((byte[])convertResult.getPayload())).build());
            }
            return Mono.empty();
        });
    }

    @Nonnull
    public Flux<DeviceMessage> decode(@Nonnull MessageDecodeContext context) {
        MqttMessage message = (MqttMessage)context.getMessage();
        byte[] payload = message.payloadAsBytes();
        return TopicMessageCodec.decode(this.mapper, TopicMessageCodec.removeProductPath(message.getTopic()), payload).switchIfEmpty(FunctionalTopicHandlers.handle(context.getDevice(), message.getTopic().split("/"), payload, this.mapper, reply -> this.doReply((MessageCodecContext)context, (TopicPayload)reply)));
    }

    private Mono<Void> doReply(MessageCodecContext context, TopicPayload reply) {
        if (context instanceof FromDeviceMessageContext) {
            return ((FromDeviceMessageContext)context).getSession().send((EncodedMessage)SimpleMqttMessage.builder().topic(reply.getTopic()).payload(reply.getPayload()).build()).then();
        }
        if (context instanceof ToDeviceMessageContext) {
            return ((ToDeviceMessageContext)context).sendToDevice((EncodedMessage)SimpleMqttMessage.builder().topic(reply.getTopic()).payload(reply.getPayload()).build()).then();
        }
        return Mono.empty();
    }
}

