/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Consumer;
import org.jetlinks.core.Value;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.codec.CoapMessage;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.metadata.ConfigScope;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.DeviceConfigScope;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.protocol.official.AbstractCoapDeviceMessageCodec;
import org.jetlinks.protocol.official.FunctionalTopicHandlers;
import org.jetlinks.protocol.official.ObjectMappers;
import org.jetlinks.protocol.official.TopicMessageCodec;
import org.jetlinks.protocol.official.cipher.Ciphers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JetLinksCoapDeviceMessageCodec
extends AbstractCoapDeviceMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(JetLinksCoapDeviceMessageCodec.class);
    public static final DefaultConfigMetadata coapConfig = new DefaultConfigMetadata("CoAP\u8ba4\u8bc1\u914d\u7f6e", "\u4f7f\u7528CoAP\u8fdb\u884c\u6570\u636e\u4e0a\u62a5\u65f6,\u9700\u8981\u5bf9\u6570\u636e\u8fdb\u884c\u52a0\u5bc6:encrypt(payload,secureKey);").add("encAlg", "\u52a0\u5bc6\u7b97\u6cd5", "\u52a0\u5bc6\u7b97\u6cd5", (DataType)new EnumType().addElement(EnumType.Element.of((String)"AES", (String)"AES\u52a0\u5bc6(ECB,PKCS#5)", (String)"\u52a0\u5bc6\u6a21\u5f0f:ECB,\u586b\u5145\u65b9\u5f0f:PKCS#5")), new ConfigScope[]{DeviceConfigScope.product}).add("secureKey", "\u5bc6\u94a5", "16\u4f4d\u5bc6\u94a5KEY", (DataType)new PasswordType());

    public Transport getSupportTransport() {
        return DefaultTransport.CoAP;
    }

    @Override
    protected Flux<DeviceMessage> decode(CoapMessage message, MessageDecodeContext context, Consumer<Object> response) {
        String path = this.getPath(message);
        String deviceId = this.getDeviceId(message);
        boolean cbor = message.getStringOption(12).map(MediaType::valueOf).map(arg_0 -> ((MediaType)MediaType.APPLICATION_CBOR).includes(arg_0)).orElse(false);
        ObjectMapper objectMapper = cbor ? ObjectMappers.CBOR_MAPPER : ObjectMappers.JSON_MAPPER;
        return context.getDevice(deviceId).flatMapMany(device -> device.getConfigs(new String[]{"encAlg", "secureKey"}).flatMapMany(configs -> {
            Ciphers ciphers = configs.getValue("encAlg").map(Value::asString).flatMap(Ciphers::of).orElse(Ciphers.AES);
            String secureKey = configs.getValue("secureKey").map(Value::asString).orElse(null);
            byte[] payload = ciphers.decrypt(message.payloadAsBytes(), secureKey);
            return TopicMessageCodec.decode(objectMapper, TopicMessageCodec.removeProductPath(path), payload).switchIfEmpty(FunctionalTopicHandlers.handle(device, path.split("/"), payload, objectMapper, reply -> Mono.fromRunnable(() -> response.accept(reply.getPayload()))));
        }));
    }
}

