/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.californium.core.coap.CoAP;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.codec.CoapMessage;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.protocol.official.AbstractCoapDeviceMessageCodec;
import org.jetlinks.protocol.official.FunctionalTopicHandlers;
import org.jetlinks.protocol.official.ObjectMappers;
import org.jetlinks.protocol.official.TopicMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JetLinksCoapDTLSDeviceMessageCodec
extends AbstractCoapDeviceMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(JetLinksCoapDTLSDeviceMessageCodec.class);
    private static final DefaultConfigMetadata coapDTLSConfig = new DefaultConfigMetadata("CoAP DTLS\u914d\u7f6e", "\u4f7f\u7528CoAP DTLS \u8fdb\u884c\u6570\u636e\u4e0a\u62a5\u9700\u8981\u5148\u8fdb\u884c\u7b7e\u540d\u8ba4\u8bc1\u83b7\u53d6token.\n\u4e4b\u540e\u4e0a\u62a5\u6570\u636e\u9700\u8981\u5728Option\u4e2d\u643a\u5e26token\u4fe1\u606f. \n\u81ea\u5b9a\u4e49Option: 2110,sign ; 2111,token ").add("secureKey", "\u5bc6\u94a5", "\u8ba4\u8bc1\u7b7e\u540d\u5bc6\u94a5", (DataType)new PasswordType());

    public Transport getSupportTransport() {
        return DefaultTransport.CoAP_DTLS;
    }

    @Override
    public Flux<DeviceMessage> decode(CoapMessage message, MessageDecodeContext context, Consumer<Object> response) {
        if (context.getDevice() == null) {
            return Flux.empty();
        }
        return Flux.defer(() -> {
            ObjectMapper objectMapper;
            String path = this.getPath(message);
            String deviceId = this.getDeviceId(message);
            String sign = message.getStringOption(2110).orElse(null);
            String token = message.getStringOption(2111).orElse(null);
            byte[] payload = message.payloadAsBytes();
            boolean cbor = message.getStringOption(12).map(MediaType::valueOf).map(arg_0 -> ((MediaType)MediaType.APPLICATION_CBOR).includes(arg_0)).orElse(false);
            ObjectMapper objectMapper2 = objectMapper = cbor ? ObjectMappers.CBOR_MAPPER : ObjectMappers.JSON_MAPPER;
            if (StringUtils.isEmpty((Object)deviceId)) {
                response.accept(CoAP.ResponseCode.UNAUTHORIZED);
                return Mono.empty();
            }
            if (path.endsWith("/request-token")) {
                return context.getDevice(deviceId).switchIfEmpty(Mono.fromRunnable(() -> response.accept(CoAP.ResponseCode.UNAUTHORIZED))).flatMap(device -> device.getConfig("secureKey").flatMap(sk -> {
                    String secureKey = sk.asString();
                    if (!this.verifySign(secureKey, deviceId, payload, sign)) {
                        response.accept(CoAP.ResponseCode.BAD_REQUEST);
                        return Mono.empty();
                    }
                    String newToken = (String)IDGenerator.MD5.generate();
                    return device.setConfig("coap-token", (Object)newToken).doOnSuccess(success -> {
                        JSONObject json = new JSONObject();
                        json.put("token", (Object)newToken);
                        response.accept(json.toJSONString());
                    });
                })).then(Mono.empty());
            }
            if (StringUtils.isEmpty((Object)token)) {
                response.accept(CoAP.ResponseCode.UNAUTHORIZED);
                return Mono.empty();
            }
            return context.getDevice(deviceId).flatMapMany(device -> device.getSelfConfig("coap-token").switchIfEmpty(Mono.fromRunnable(() -> response.accept(CoAP.ResponseCode.UNAUTHORIZED))).flatMapMany(value -> {
                String tk = value.asString();
                if (!token.equals(tk)) {
                    response.accept(CoAP.ResponseCode.UNAUTHORIZED);
                    return Mono.empty();
                }
                return TopicMessageCodec.decode(objectMapper, TopicMessageCodec.removeProductPath(path), payload).switchIfEmpty(FunctionalTopicHandlers.handle(device, path.split("/"), payload, objectMapper, reply -> Mono.fromRunnable(() -> response.accept(reply.getPayload()))));
            })).doOnComplete(() -> response.accept(CoAP.ResponseCode.CREATED)).doOnError(error -> {
                log.error("decode coap message error", error);
                response.accept(CoAP.ResponseCode.BAD_REQUEST);
            });
        });
    }

    protected boolean verifySign(String secureKey, String deviceId, byte[] payload, String sign) {
        byte[] secureKeyBytes = secureKey.getBytes();
        byte[] signPayload = Arrays.copyOf(payload, payload.length + secureKeyBytes.length);
        System.arraycopy(secureKeyBytes, 0, signPayload, 0, secureKeyBytes.length);
        if (StringUtils.isEmpty((Object)secureKey) || !DigestUtils.md5Hex((byte[])signPayload).equalsIgnoreCase(sign)) {
            log.info("device [{}] coap sign [{}] error, payload:{}", new Object[]{deviceId, sign, payload});
            return false;
        }
        return true;
    }
}

