/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.parsetools.RecordParser;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.jetlinks.core.message.AcknowledgeDeviceMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.protocol.official.binary.BinaryDeviceOnlineMessage;
import org.jetlinks.protocol.official.binary.BinaryMessageType;
import org.jetlinks.protocol.official.tcp.TcpDeviceMessageCodec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TcpDevice {
    public static void main(String[] args) {
        String[] stringArray;
        int count;
        Vertx vertx = Vertx.vertx();
        int start = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        int n = count = args.length > 1 ? Integer.parseInt(args[1]) : 8000;
        if (args.length > 2) {
            stringArray = args[2].split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "0.0.0.0";
        }
        String[] hosts = stringArray;
        Flux.range((int)start, (int)count).flatMap(i -> Mono.create(sink -> {
            NetClientOptions conf = new NetClientOptions().setTcpKeepAlive(true);
            conf.setLocalAddress(hosts[i % hosts.length]);
            vertx.createNetClient(conf).connect(8802, "localhost").onFailure(err -> {
                System.out.println(err.getMessage());
                sink.success();
            }).onSuccess(socket -> {
                RecordParser parser = RecordParser.newFixed((int)4);
                AtomicReference buffer = new AtomicReference();
                parser.handler(buf -> buffer.accumulateAndGet(buf, (a, b) -> {
                    if (a == null) {
                        parser.fixedSizeMode(buf.getInt(0));
                        return b;
                    }
                    parser.fixedSizeMode(4);
                    sink.success((Object)("tcp-off-" + i + ":" + socket.localAddress()));
                    BinaryMessageType.read(b.getByteBuf(), null, (downstream, seq) -> {
                        TcpDevice.handleDownStream(downstream, seq, socket);
                        return null;
                    });
                    return null;
                }));
                socket.closeHandler(s -> {
                    System.out.println("tcp-off-" + i + ":" + socket.localAddress() + "closed");
                    sink.success();
                }).exceptionHandler(er -> {
                    System.out.println("tcp-off-" + i + ":" + socket.localAddress() + " " + er.getMessage());
                    sink.success();
                }).handler((Handler)parser);
                DeviceOnlineMessage message = new DeviceOnlineMessage();
                message.addHeader(BinaryDeviceOnlineMessage.loginToken, (Object)"test");
                message.setDeviceId("tcp-off-" + i);
                socket.write((Object)Buffer.buffer((ByteBuf)TcpDeviceMessageCodec.wrapByteByf(BinaryMessageType.write((DeviceMessage)message, Unpooled.buffer()))));
            });
        }), 1024).count().subscribe(System.out::println);
        System.in.read();
    }

    protected static void handleDownStream(DeviceMessage downstream, int seq, NetSocket socket) {
        if (!(downstream instanceof AcknowledgeDeviceMessage)) {
            // empty if block
        }
        WritePropertyMessageReply reply = null;
        if (downstream instanceof ReadPropertyMessage) {
            reply = ((ReadPropertyMessage)downstream).newReply().success(Collections.singletonMap("temp0", Float.valueOf(ThreadLocalRandom.current().nextFloat() * 100.0f)));
        } else if (downstream instanceof WritePropertyMessage) {
            reply = ((WritePropertyMessage)downstream).newReply().success(((WritePropertyMessage)downstream).getProperties());
        }
        if (reply != null) {
            socket.write((Object)Buffer.buffer((ByteBuf)TcpDeviceMessageCodec.wrapByteByf(BinaryMessageType.write(reply, seq, Unpooled.buffer()))));
        }
    }
}

