/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official.http;

import com.fasterxml.jackson.core.JsonParseException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpExchangeMessage;
import org.jetlinks.core.message.codec.http.HttpResponseMessage;
import org.jetlinks.core.message.codec.http.SimpleHttpResponseMessage;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.core.trace.DeviceTracer;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.protocol.official.ObjectMappers;
import org.jetlinks.protocol.official.TopicMessageCodec;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JetLinksHttpDeviceMessageCodec
implements DeviceMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(JetLinksHttpDeviceMessageCodec.class);
    public static final DefaultConfigMetadata httpConfig = new DefaultConfigMetadata("HTTP\u8ba4\u8bc1\u914d\u7f6e", "\u4f7f\u7528HTTP Bearer Token\u8fdb\u884c\u8ba4\u8bc1").add("bearer_token", "Token", "Token", (DataType)new PasswordType());
    private final Transport transport;

    public JetLinksHttpDeviceMessageCodec(Transport transport) {
        this.transport = transport;
    }

    public JetLinksHttpDeviceMessageCodec() {
        this((Transport)DefaultTransport.HTTP);
    }

    public Transport getSupportTransport() {
        return this.transport;
    }

    @Nonnull
    public Mono<MqttMessage> encode(@Nonnull MessageEncodeContext context) {
        return Mono.empty();
    }

    private static SimpleHttpResponseMessage unauthorized(String msg) {
        return SimpleHttpResponseMessage.builder().contentType(MediaType.APPLICATION_JSON).body("{\"success\":false,\"code\":\"unauthorized\",\"message\":\"" + msg + "\"}").status(401).build();
    }

    private static SimpleHttpResponseMessage badRequest() {
        return SimpleHttpResponseMessage.builder().contentType(MediaType.APPLICATION_JSON).body("{\"success\":false,\"code\":\"bad_request\"}").status(400).build();
    }

    @Nonnull
    public Flux<DeviceMessage> decode(@Nonnull MessageDecodeContext context) {
        HttpExchangeMessage message = (HttpExchangeMessage)context.getMessage();
        Header header = message.getHeader("Authorization").orElse(null);
        if (header == null || header.getValue() == null || header.getValue().length == 0) {
            return message.response((HttpResponseMessage)JetLinksHttpDeviceMessageCodec.unauthorized("Authorization header is required")).thenMany((Publisher)Mono.empty());
        }
        String[] token = header.getValue()[0].split(" ");
        if (token.length == 1) {
            return message.response((HttpResponseMessage)JetLinksHttpDeviceMessageCodec.unauthorized("Illegal token format")).thenMany((Publisher)Mono.empty());
        }
        String basicToken = token[1];
        String[] paths = TopicMessageCodec.removeProductPath(message.getPath());
        if (paths.length < 1) {
            return message.response((HttpResponseMessage)JetLinksHttpDeviceMessageCodec.badRequest()).thenMany((Publisher)Mono.empty());
        }
        String deviceId = paths[1];
        return (Flux)context.getDevice(deviceId).flatMap(device -> device.getConfig("bearer_token")).filter(value -> Objects.equals(value.asString(), basicToken)).switchIfEmpty(Mono.defer(() -> message.response((HttpResponseMessage)JetLinksHttpDeviceMessageCodec.unauthorized("Device no register or token not match")).then(Mono.empty()))).flatMapMany(ignore -> this.doDecode(message, paths)).switchOnFirst((s, flux) -> {
            if (!s.hasValue()) {
                return message.response((HttpResponseMessage)JetLinksHttpDeviceMessageCodec.badRequest()).then(Mono.empty());
            }
            Mono handler = message.ok("{\"success\":true}");
            return handler.thenMany((Publisher)flux);
        }).onErrorResume(err -> message.error(500, this.getErrorMessage((Throwable)err)).then(Mono.error((Throwable)err))).as((Function)FluxTracer.create((String)DeviceTracer.SpanName.decode((String)deviceId), builder -> builder.setAttribute(DeviceTracer.SpanKey.message, (Object)message.print())));
    }

    private Flux<DeviceMessage> doDecode(HttpExchangeMessage message, String[] paths) {
        return message.payload().flatMapMany(buf -> {
            byte[] body = ByteBufUtil.getBytes((ByteBuf)buf);
            return TopicMessageCodec.decode(ObjectMappers.JSON_MAPPER, paths, body);
        });
    }

    public String getErrorMessage(Throwable err) {
        if (err instanceof JsonParseException) {
            return "{\"success\":false,\"code\":\"request_body_format_error\"}";
        }
        return "{\"success\":false,\"code\":\"server_error\"}";
    }
}

