/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official.binary;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetlinks.protocol.official.ObjectMappers;

public enum DataType {
    NULL{

        @Override
        public Object read(ByteBuf buf) {
            return null;
        }

        @Override
        public void write(ByteBuf buf, Object value) {
        }
    }
    ,
    BOOLEAN{

        @Override
        public Object read(ByteBuf buf) {
            return buf.readBoolean();
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeBoolean(((Boolean)value).booleanValue());
        }
    }
    ,
    INT8{

        @Override
        public Object read(ByteBuf buf) {
            return buf.readByte();
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeByte((int)((Byte)value).byteValue());
        }
    }
    ,
    INT16{

        @Override
        public Object read(ByteBuf buf) {
            return buf.readShort();
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeShort((int)((Short)value).shortValue());
        }
    }
    ,
    INT32{

        @Override
        public Object read(ByteBuf buf) {
            return buf.readInt();
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeInt(((Integer)value).intValue());
        }
    }
    ,
    INT64{

        @Override
        public Object read(ByteBuf buf) {
            return buf.readLong();
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeLong(((Long)value).longValue());
        }
    }
    ,
    UINT8{

        @Override
        public Object read(ByteBuf buf) {
            return buf.readUnsignedByte();
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeByte((int)((Byte)value).byteValue());
        }
    }
    ,
    UINT16{

        @Override
        public Object read(ByteBuf buf) {
            return buf.readUnsignedShort();
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeShort((int)((Short)value).shortValue());
        }
    }
    ,
    UINT32{

        @Override
        public Object read(ByteBuf buf) {
            return buf.readUnsignedInt();
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeInt(((Integer)value).intValue());
        }
    }
    ,
    FLOAT{

        @Override
        public Object read(ByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeFloat(((Float)value).floatValue());
        }
    }
    ,
    DOUBLE{

        @Override
        public Object read(ByteBuf buf) {
            return buf.readDouble();
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            buf.writeDouble(((Double)value).doubleValue());
        }
    }
    ,
    STRING{

        @Override
        public Object read(ByteBuf buf) {
            int len = buf.readUnsignedShort();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            String str = (String)value;
            buf.writeShort(str.length());
            buf.writeBytes(str.getBytes());
        }
    }
    ,
    BINARY{

        @Override
        public Object read(ByteBuf buf) {
            int len = buf.readUnsignedShort();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes);
            return bytes;
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            byte[] bytes = (byte[])value;
            buf.writeShort(bytes.length);
            buf.writeBytes(bytes);
        }
    }
    ,
    ARRAY{

        @Override
        public Object read(ByteBuf buf) {
            int len = buf.readUnsignedShort();
            ArrayList<Object> array = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                array.add(14.readFrom(buf));
            }
            return array;
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            Collection array = (Collection)value;
            buf.writeShort(array.size());
            for (Object o : array) {
                14.writeTo(o, buf);
            }
        }
    }
    ,
    OBJECT{

        @Override
        public Object read(ByteBuf buf) {
            int len = buf.readUnsignedShort();
            LinkedHashMap data = Maps.newLinkedHashMapWithExpectedSize((int)len);
            for (int i = 0; i < len; ++i) {
                data.put((String)STRING.read(buf), 15.readFrom(buf));
            }
            return data;
        }

        @Override
        public void write(ByteBuf buf, Object value) {
            Map data = value instanceof Map ? (Map)value : (Map)ObjectMappers.JSON_MAPPER.convertValue(value, Map.class);
            buf.writeShort(data.size());
            for (Map.Entry entry : data.entrySet()) {
                STRING.write(buf, entry.getKey());
                15.writeTo(entry.getValue(), buf);
            }
        }
    };

    private static final DataType[] VALUES;

    public abstract Object read(ByteBuf var1);

    public abstract void write(ByteBuf var1, Object var2);

    public static Object readFrom(ByteBuf buf) {
        return VALUES[buf.readUnsignedByte()].read(buf);
    }

    public static void writeTo(Object data, ByteBuf buf) {
        DataType type = DataType.loopUpType(data);
        buf.writeByte(type.ordinal());
        type.write(buf, data);
    }

    private static DataType loopUpType(Object data) {
        if (data == null) {
            return NULL;
        }
        if (data instanceof Boolean) {
            return BOOLEAN;
        }
        if (data instanceof Byte) {
            return INT8;
        }
        if (data instanceof Short) {
            return INT16;
        }
        if (data instanceof Integer) {
            return INT32;
        }
        if (data instanceof Long) {
            return INT64;
        }
        if (data instanceof Float) {
            return FLOAT;
        }
        if (data instanceof Double) {
            return DOUBLE;
        }
        if (data instanceof String) {
            return STRING;
        }
        if (data instanceof byte[]) {
            return BINARY;
        }
        if (data instanceof Collection) {
            return ARRAY;
        }
        if (data instanceof Map) {
            return OBJECT;
        }
        throw new IllegalArgumentException("Unsupported data type: " + data.getClass());
    }

    public static void main(String[] args) {
        System.out.println("| Byte | Type |");
        System.out.println("|  ----  | ----  |");
        for (DataType value : DataType.values()) {
            System.out.print("|");
            System.out.print("0x0" + Integer.toString(value.ordinal(), 16));
            System.out.print("|");
            System.out.print(value.name());
            System.out.print("|");
            System.out.println();
        }
        System.out.println();
    }

    static {
        VALUES = DataType.values();
    }
}

