/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official.binary;

import io.netty.buffer.ByteBuf;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.protocol.official.binary.BinaryMessage;
import org.jetlinks.protocol.official.binary.DataType;

public abstract class BinaryReplyMessage<T extends DeviceMessageReply>
implements BinaryMessage<T> {
    private T message;

    protected abstract T newMessage();

    @Override
    public final void read(ByteBuf buf) {
        this.message = this.newMessage();
        boolean success = buf.readBoolean();
        if (success) {
            this.doReadSuccess(this.message, buf);
        } else {
            this.message.success(false);
            this.message.code(String.valueOf(DataType.readFrom(buf)));
            this.message.message(String.valueOf(DataType.readFrom(buf)));
        }
    }

    protected abstract void doReadSuccess(T var1, ByteBuf var2);

    protected abstract void doWriteSuccess(T var1, ByteBuf var2);

    @Override
    public final void write(ByteBuf buf) {
        buf.writeBoolean(this.message.isSuccess());
        if (this.message.isSuccess()) {
            this.doWriteSuccess(this.message, buf);
        } else {
            DataType.writeTo(this.message.getCode(), buf);
            DataType.writeTo(this.message.getMessage(), buf);
        }
    }

    @Override
    public void setMessage(T message) {
        this.message = message;
    }

    @Override
    public T getMessage() {
        return this.message;
    }
}

