/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official.binary;

import io.netty.buffer.ByteBuf;
import org.jetlinks.core.message.AcknowledgeDeviceMessage;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.protocol.official.binary.AckCode;
import org.jetlinks.protocol.official.binary.BinaryMessage;
import org.jetlinks.protocol.official.binary.BinaryMessageType;

public class BinaryAcknowledgeDeviceMessage
implements BinaryMessage<AcknowledgeDeviceMessage> {
    public static final HeaderKey<String> codeHeader = HeaderKey.of((String)"code", (Object)AckCode.ok.name());
    private AcknowledgeDeviceMessage message;

    @Override
    public BinaryMessageType getType() {
        return BinaryMessageType.ack;
    }

    @Override
    public void read(ByteBuf buf) {
        this.message = new AcknowledgeDeviceMessage();
        AckCode code = AckCode.values()[buf.readUnsignedByte()];
        this.message.addHeader(codeHeader, (Object)code.name());
    }

    @Override
    public void write(ByteBuf buf) {
        AckCode code = AckCode.valueOf((String)this.message.getHeaderOrDefault(codeHeader));
        buf.writeByte(code.ordinal());
    }

    @Override
    public void setMessage(AcknowledgeDeviceMessage message) {
        this.message = message;
    }

    @Override
    public AcknowledgeDeviceMessage getMessage() {
        return this.message;
    }
}

