/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.ChildDeviceMessageReply;
import org.jetlinks.core.message.DerivedMetadataMessage;
import org.jetlinks.core.message.DeviceLogMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceOfflineMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.DeviceRegisterMessage;
import org.jetlinks.core.message.DeviceUnRegisterMessage;
import org.jetlinks.core.message.DirectDeviceMessage;
import org.jetlinks.core.message.DisconnectDeviceMessage;
import org.jetlinks.core.message.DisconnectDeviceMessageReply;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.UpdateTagMessage;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.message.firmware.ReadFirmwareMessage;
import org.jetlinks.core.message.firmware.ReadFirmwareMessageReply;
import org.jetlinks.core.message.firmware.ReportFirmwareMessage;
import org.jetlinks.core.message.firmware.RequestFirmwareMessage;
import org.jetlinks.core.message.firmware.RequestFirmwareMessageReply;
import org.jetlinks.core.message.firmware.UpgradeFirmwareMessage;
import org.jetlinks.core.message.firmware.UpgradeFirmwareMessageReply;
import org.jetlinks.core.message.firmware.UpgradeFirmwareProgressMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.core.message.state.DeviceStateCheckMessage;
import org.jetlinks.core.message.state.DeviceStateCheckMessageReply;
import org.jetlinks.core.route.MqttRoute;
import org.jetlinks.core.utils.TopicUtils;
import org.jetlinks.protocol.official.TopicPayload;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public enum TopicMessageCodec {
    reportProperty("/*/properties/report", ReportPropertyMessage.class, route -> route.upstream(true).downstream(false).group("\u5c5e\u6027\u4e0a\u62a5").description("\u4e0a\u62a5\u7269\u6a21\u578b\u5c5e\u6027\u6570\u636e").example("{\"properties\":{\"\u5c5e\u6027ID\":\"\u5c5e\u6027\u503c\"}}")),
    readProperty("/*/properties/read", ReadPropertyMessage.class, route -> route.upstream(false).downstream(true).group("\u8bfb\u53d6\u5c5e\u6027").description("\u5e73\u53f0\u4e0b\u53d1\u8bfb\u53d6\u7269\u6a21\u578b\u5c5e\u6027\u6570\u636e\u6307\u4ee4").example("{\"messageId\":\"\u6d88\u606fID,\u56de\u590d\u65f6\u9700\u8981\u4e00\u81f4.\",\"properties\":[\"\u5c5e\u6027ID\"]}")),
    readPropertyReply("/*/properties/read/reply", ReadPropertyMessageReply.class, route -> route.upstream(true).downstream(false).group("\u8bfb\u53d6\u5c5e\u6027").description("\u5bf9\u5e73\u53f0\u4e0b\u53d1\u7684\u8bfb\u53d6\u5c5e\u6027\u6307\u4ee4\u8fdb\u884c\u54cd\u5e94").example("{\"messageId\":\"\u6d88\u606fID,\u4e0e\u8bfb\u53d6\u6307\u4ee4\u4e2d\u7684ID\u4e00\u81f4.\",\"properties\":{\"\u5c5e\u6027ID\":\"\u5c5e\u6027\u503c\"}}")),
    writeProperty("/*/properties/write", WritePropertyMessage.class, route -> route.upstream(false).downstream(true).group("\u4fee\u6539\u5c5e\u6027").description("\u5e73\u53f0\u4e0b\u53d1\u4fee\u6539\u7269\u6a21\u578b\u5c5e\u6027\u6570\u636e\u6307\u4ee4").example("{\"messageId\":\"\u6d88\u606fID,\u56de\u590d\u65f6\u9700\u8981\u4e00\u81f4.\",\"properties\":{\"\u5c5e\u6027ID\":\"\u5c5e\u6027\u503c\"}}")),
    writePropertyReply("/*/properties/write/reply", WritePropertyMessageReply.class, route -> route.upstream(true).downstream(false).group("\u4fee\u6539\u5c5e\u6027").description("\u5bf9\u5e73\u53f0\u4e0b\u53d1\u7684\u4fee\u6539\u5c5e\u6027\u6307\u4ee4\u8fdb\u884c\u54cd\u5e94").example("{\"messageId\":\"\u6d88\u606fID,\u4e0e\u4fee\u6539\u6307\u4ee4\u4e2d\u7684ID\u4e00\u81f4.\",\"properties\":{\"\u5c5e\u6027ID\":\"\u5c5e\u6027\u503c\"}}")),
    event("/*/event/*", (Class)EventMessage.class, route -> route.upstream(true).downstream(false).group("\u4e8b\u4ef6\u4e0a\u62a5").description("\u4e0a\u62a5\u7269\u6a21\u578b\u4e8b\u4ef6\u6570\u636e").example("{\"data\":{\"key\":\"value\"}}")){

        @Override
        protected void transMqttTopic(String[] topic) {
            topic[topic.length - 1] = "{eventId:\u4e8b\u4ef6ID}";
        }

        @Override
        Publisher<DeviceMessage> doDecode(ObjectMapper mapper, String[] topic, byte[] payload) {
            String event = topic[topic.length - 1];
            return Mono.from(super.doDecode(mapper, topic, payload)).cast(EventMessage.class).doOnNext(e -> e.setEvent(event)).cast(DeviceMessage.class);
        }

        @Override
        void refactorTopic(String[] topics, DeviceMessage message) {
            super.refactorTopic(topics, message);
            EventMessage event = (EventMessage)message;
            topics[topics.length - 1] = String.valueOf(event.getEvent());
        }
    }
    ,
    functionInvoke("/*/function/invoke", FunctionInvokeMessage.class, route -> route.upstream(false).downstream(true).group("\u8c03\u7528\u529f\u80fd").description("\u5e73\u53f0\u4e0b\u53d1\u529f\u80fd\u8c03\u7528\u6307\u4ee4").example("{\"messageId\":\"\u6d88\u606fID,\u56de\u590d\u65f6\u9700\u8981\u4e00\u81f4.\",\"functionId\":\"\u529f\u80fd\u6807\u8bc6\",\"inputs\":[{\"name\":\"\u53c2\u6570\u540d\",\"value\":\"\u53c2\u6570\u503c\"}]}")),
    functionInvokeReply("/*/function/invoke/reply", FunctionInvokeMessageReply.class, route -> route.upstream(true).downstream(false).group("\u8c03\u7528\u529f\u80fd").description("\u8bbe\u5907\u54cd\u5e94\u5e73\u53f0\u4e0b\u53d1\u7684\u529f\u80fd\u8c03\u7528\u6307\u4ee4").example("{\"messageId\":\"\u6d88\u606fID,\u4e0e\u4e0b\u53d1\u6307\u4ee4\u4e2d\u7684messageId\u4e00\u81f4.\",\"output\":\"\u8f93\u51fa\u7ed3\u679c,\u683c\u5f0f\u4e0e\u7269\u6a21\u578b\u4e2d\u5b9a\u4e49\u7684\u7c7b\u578b\u4e00\u81f4\"")),
    child("/*/child/*/**", (Class)ChildDeviceMessage.class, route -> route.upstream(true).downstream(true).group("\u5b50\u8bbe\u5907\u6d88\u606f").description("\u7f51\u5173\u4e0a\u62a5\u6216\u8005\u5e73\u53f0\u4e0b\u53d1\u5b50\u8bbe\u5907\u6d88\u606f")){

        @Override
        protected void transMqttTopic(String[] topic) {
            topic[topic.length - 1] = "{#:\u5b50\u8bbe\u5907\u76f8\u5e94\u64cd\u4f5c\u7684topic}";
            topic[topic.length - 2] = "{childDeviceId:\u5b50\u8bbe\u5907ID}";
        }

        @Override
        public Publisher<DeviceMessage> doDecode(ObjectMapper mapper, String[] topic, byte[] payload) {
            String[] _topic = Arrays.copyOfRange(topic, 2, topic.length);
            _topic[0] = "";
            return TopicMessageCodec.decode(mapper, _topic, payload).map(childMsg -> {
                ChildDeviceMessage msg = new ChildDeviceMessage();
                msg.setDeviceId(topic[1]);
                msg.setChildDeviceMessage((Message)childMsg);
                msg.setTimestamp(childMsg.getTimestamp());
                msg.setMessageId(childMsg.getMessageId());
                return msg;
            });
        }

        @Override
        protected TopicPayload doEncode(ObjectMapper mapper, String[] topics, DeviceMessage message) {
            ChildDeviceMessage deviceMessage = (ChildDeviceMessage)message;
            DeviceMessage childMessage = (DeviceMessage)deviceMessage.getChildDeviceMessage();
            TopicPayload payload = TopicMessageCodec.encode(mapper, childMessage);
            String[] childTopic = payload.getTopic().split("/");
            CharSequence[] topic = new String[topics.length + childTopic.length - 3];
            System.arraycopy(topics, 0, topic, 0, topics.length - 1);
            System.arraycopy(childTopic, 1, topic, topics.length - 2, childTopic.length - 1);
            this.refactorTopic((String[])topic, message);
            payload.setTopic(String.join((CharSequence)"/", topic));
            return payload;
        }
    }
    ,
    childReply("/*/child-reply/*/**", (Class)ChildDeviceMessageReply.class, route -> route.upstream(true).downstream(true).group("\u5b50\u8bbe\u5907\u6d88\u606f").description("\u7f51\u5173\u56de\u590d\u5e73\u53f0\u4e0b\u53d1\u7ed9\u5b50\u8bbe\u5907\u7684\u6307\u4ee4\u7ed3\u679c")){

        @Override
        protected void transMqttTopic(String[] topic) {
            topic[topic.length - 1] = "{#:\u5b50\u8bbe\u5907\u76f8\u5e94\u64cd\u4f5c\u7684topic}";
            topic[topic.length - 2] = "{childDeviceId:\u5b50\u8bbe\u5907ID}";
        }

        @Override
        public Publisher<DeviceMessage> doDecode(ObjectMapper mapper, String[] topic, byte[] payload) {
            String[] _topic = Arrays.copyOfRange(topic, 2, topic.length);
            _topic[0] = "";
            return TopicMessageCodec.decode(mapper, _topic, payload).map(childMsg -> {
                ChildDeviceMessageReply msg = new ChildDeviceMessageReply();
                msg.setDeviceId(topic[1]);
                msg.setChildDeviceMessage((Message)childMsg);
                msg.setTimestamp(childMsg.getTimestamp());
                msg.setMessageId(childMsg.getMessageId());
                return msg;
            });
        }

        @Override
        protected TopicPayload doEncode(ObjectMapper mapper, String[] topics, DeviceMessage message) {
            ChildDeviceMessageReply deviceMessage = (ChildDeviceMessageReply)message;
            DeviceMessage childMessage = (DeviceMessage)deviceMessage.getChildDeviceMessage();
            TopicPayload payload = TopicMessageCodec.encode(mapper, childMessage);
            String[] childTopic = payload.getTopic().split("/");
            CharSequence[] topic = new String[topics.length + childTopic.length - 3];
            System.arraycopy(topics, 0, topic, 0, topics.length - 1);
            System.arraycopy(childTopic, 1, topic, topics.length - 2, childTopic.length - 1);
            this.refactorTopic((String[])topic, message);
            payload.setTopic(String.join((CharSequence)"/", topic));
            return payload;
        }
    }
    ,
    updateTag("/*/tags", UpdateTagMessage.class, route -> route.upstream(true).downstream(false).group("\u66f4\u65b0\u6807\u7b7e").description("\u66f4\u65b0\u6807\u7b7e\u6570\u636e").example("{\"tags\":{\"key\",\"value\"}}")),
    register("/*/register", DeviceRegisterMessage.class),
    unregister("/*/unregister", DeviceUnRegisterMessage.class),
    upgradeFirmware("/*/firmware/upgrade", UpgradeFirmwareMessage.class),
    upgradeFirmwareReply("/*/firmware/upgrade/reply", UpgradeFirmwareMessageReply.class),
    upgradeProcessFirmware("/*/firmware/upgrade/progress", UpgradeFirmwareProgressMessage.class),
    requestFirmware("/*/firmware/pull", RequestFirmwareMessage.class),
    requestFirmwareReply("/*/firmware/pull/reply", RequestFirmwareMessageReply.class),
    reportFirmware("/*/firmware/report", ReportFirmwareMessage.class),
    readFirmware("/*/firmware/read", ReadFirmwareMessage.class),
    readFirmwareReply("/*/firmware/read/reply", ReadFirmwareMessageReply.class),
    derivedMetadata("/*/metadata/derived", DerivedMetadataMessage.class),
    direct("/*/direct", DirectDeviceMessage.class){

        @Override
        public Publisher<DeviceMessage> doDecode(ObjectMapper mapper, String[] topic, byte[] payload) {
            DirectDeviceMessage message = new DirectDeviceMessage();
            message.setDeviceId(topic[1]);
            message.setPayload(payload);
            return Mono.just((Object)message);
        }
    }
    ,
    disconnect("/*/disconnect", DisconnectDeviceMessage.class),
    disconnectReply("/*/disconnect/reply", DisconnectDeviceMessageReply.class),
    online("/*/online", DeviceOnlineMessage.class, builder -> builder.upstream(true).group("\u72b6\u6001\u7ba1\u7406").description("\u8bbe\u5907\u4e0a\u7ebf")),
    offline("/*/offline", DeviceOfflineMessage.class, builder -> builder.upstream(true).group("\u72b6\u6001\u7ba1\u7406").description("\u8bbe\u5907\u79bb\u7ebf")),
    log("/*/log", DeviceLogMessage.class),
    stateCheck("/*/state-check", DeviceStateCheckMessage.class),
    stateCheckReply("/*/state-check/reply", DeviceStateCheckMessageReply.class);

    private final String[] pattern;
    private final MqttRoute route;
    private final Class<? extends DeviceMessage> type;

    private TopicMessageCodec(String topic, Class<? extends DeviceMessage> type, Function<MqttRoute.Builder, MqttRoute.Builder> routeCustom) {
        this.pattern = topic.split("/");
        this.type = type;
        this.route = routeCustom.apply(this.toRoute()).build();
    }

    private TopicMessageCodec(String topic, Class<? extends DeviceMessage> type) {
        this.pattern = topic.split("/");
        this.type = type;
        this.route = null;
    }

    protected void transMqttTopic(String[] topic) {
    }

    private MqttRoute.Builder toRoute() {
        String[] topics = new String[this.pattern.length];
        System.arraycopy(this.pattern, 0, topics, 0, this.pattern.length);
        topics[0] = "{productId:\u4ea7\u54c1ID}";
        topics[1] = "{deviceId:\u8bbe\u5907ID}";
        this.transMqttTopic(topics);
        StringJoiner joiner = new StringJoiner("/", "/", "");
        for (String topic : topics) {
            joiner.add(topic);
        }
        return MqttRoute.builder((String)joiner.toString()).qos(1);
    }

    public MqttRoute getRoute() {
        return this.route;
    }

    public static Flux<DeviceMessage> decode(ObjectMapper mapper, String[] topics, byte[] payload) {
        return Mono.justOrEmpty(TopicMessageCodec.fromTopic(topics)).flatMapMany(topicMessageCodec -> topicMessageCodec.doDecode(mapper, topics, payload));
    }

    public static Flux<DeviceMessage> decode(ObjectMapper mapper, String topic, byte[] payload) {
        return TopicMessageCodec.decode(mapper, topic.split("/"), payload);
    }

    public static TopicPayload encode(ObjectMapper mapper, DeviceMessage message) {
        return TopicMessageCodec.fromMessage(message).orElseThrow(() -> new UnsupportedOperationException("unsupported message:" + message.getMessageType())).doEncode(mapper, message);
    }

    static Optional<TopicMessageCodec> fromTopic(String[] topic) {
        for (TopicMessageCodec value : TopicMessageCodec.values()) {
            if (!TopicUtils.match((String[])value.pattern, (String[])topic)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    static Optional<TopicMessageCodec> fromMessage(DeviceMessage message) {
        for (TopicMessageCodec value : TopicMessageCodec.values()) {
            if (value.type != message.getClass()) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    Publisher<DeviceMessage> doDecode(ObjectMapper mapper, String[] topic, byte[] payload) {
        return Mono.fromCallable(() -> {
            DeviceMessage message = (DeviceMessage)mapper.readValue(payload, this.type);
            FastBeanCopier.copy(Collections.singletonMap("deviceId", topic[1]), (Object)message, (String[])new String[0]);
            return message;
        });
    }

    TopicPayload doEncode(ObjectMapper mapper, String[] topics, DeviceMessage message) {
        this.refactorTopic(topics, message);
        return TopicPayload.of(String.join((CharSequence)"/", topics), mapper.writeValueAsBytes((Object)message));
    }

    TopicPayload doEncode(ObjectMapper mapper, DeviceMessage message) {
        String[] topics = Arrays.copyOf(this.pattern, this.pattern.length);
        return this.doEncode(mapper, topics, message);
    }

    void refactorTopic(String[] topics, DeviceMessage message) {
        topics[1] = message.getDeviceId();
    }

    public static String[] removeProductPath(String topic) {
        if (!topic.startsWith("/")) {
            topic = "/" + topic;
        }
        String[] topicArr = topic.split("/");
        String[] topics = Arrays.copyOfRange(topicArr, 1, topicArr.length);
        topics[0] = "";
        return topics;
    }
}

