/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.function.Function;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.utils.TopicUtils;
import org.jetlinks.protocol.official.TopicPayload;
import org.jetlinks.protocol.official.functional.TimeSyncRequest;
import org.jetlinks.protocol.official.functional.TimeSyncResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public enum FunctionalTopicHandlers {
    timeSync("/*/*/time-sync"){

        Mono<DeviceMessage> doHandle(DeviceOperator device, String[] topic, byte[] payload, ObjectMapper mapper, Function<TopicPayload, Mono<Void>> sender) {
            TopicPayload topicPayload = new TopicPayload();
            topicPayload.setTopic(String.join((CharSequence)"/", topic) + "/reply");
            TimeSyncRequest msg = (TimeSyncRequest)mapper.readValue(payload, TimeSyncRequest.class);
            TimeSyncResponse response = TimeSyncResponse.of(msg.getMessageId(), System.currentTimeMillis());
            topicPayload.setPayload(mapper.writeValueAsBytes((Object)response));
            return sender.apply(topicPayload).then(Mono.empty());
        }
    };

    private final String[] pattern;

    private FunctionalTopicHandlers(String topic) {
        this.pattern = topic.split("/");
    }

    abstract Publisher<DeviceMessage> doHandle(DeviceOperator var1, String[] var2, byte[] var3, ObjectMapper var4, Function<TopicPayload, Mono<Void>> var5);

    public static Publisher<DeviceMessage> handle(DeviceOperator device, String[] topic, byte[] payload, ObjectMapper mapper, Function<TopicPayload, Mono<Void>> sender) {
        return Mono.justOrEmpty(FunctionalTopicHandlers.fromTopic(topic)).flatMapMany(handler -> handler.doHandle(device, topic, payload, mapper, sender));
    }

    static Optional<FunctionalTopicHandlers> fromTopic(String[] topic) {
        for (FunctionalTopicHandlers value : FunctionalTopicHandlers.values()) {
            if (!TopicUtils.match((String[])value.pattern, (String[])topic)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

