/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.protocol.official;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.eclipse.californium.core.coap.CoAP;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.codec.CoapExchangeMessage;
import org.jetlinks.core.message.codec.CoapMessage;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.protocol.official.TopicMessageCodec;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractCoapDeviceMessageCodec
implements DeviceMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(AbstractCoapDeviceMessageCodec.class);

    protected abstract Flux<DeviceMessage> decode(CoapMessage var1, MessageDecodeContext var2, Consumer<Object> var3);

    protected String getPath(CoapMessage message) {
        String path = message.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    protected String getDeviceId(CoapMessage message) {
        String deviceId = message.getStringOption(2100).orElse(null);
        String[] paths = TopicMessageCodec.removeProductPath(this.getPath(message));
        if (StringUtils.isEmpty((Object)deviceId) && paths.length > 1) {
            deviceId = paths[1];
        }
        return deviceId;
    }

    @Nonnull
    public Flux<DeviceMessage> decode(@Nonnull MessageDecodeContext context) {
        if (context.getMessage() instanceof CoapExchangeMessage) {
            CoapExchangeMessage exchangeMessage = (CoapExchangeMessage)context.getMessage();
            AtomicBoolean alreadyReply = new AtomicBoolean();
            Consumer<Object> responseHandler = resp -> {
                if (alreadyReply.compareAndSet(false, true)) {
                    if (resp instanceof CoAP.ResponseCode) {
                        exchangeMessage.getExchange().respond((CoAP.ResponseCode)resp);
                    }
                    if (resp instanceof String) {
                        exchangeMessage.getExchange().respond((String)resp);
                    }
                    if (resp instanceof byte[]) {
                        exchangeMessage.getExchange().respond(CoAP.ResponseCode.CONTENT, (byte[])resp);
                    }
                }
            };
            return this.decode((CoapMessage)exchangeMessage, context, responseHandler).doOnComplete(() -> responseHandler.accept(CoAP.ResponseCode.CREATED)).doOnError(error -> {
                log.error("decode coap message error", error);
                responseHandler.accept(CoAP.ResponseCode.BAD_REQUEST);
            }).switchIfEmpty((Publisher)Mono.fromRunnable(() -> responseHandler.accept(CoAP.ResponseCode.BAD_REQUEST)));
        }
        if (context.getMessage() instanceof CoapMessage) {
            return this.decode((CoapMessage)context.getMessage(), context, resp -> log.info("skip response coap request:{}", resp));
        }
        return Flux.empty();
    }

    @Nonnull
    public Publisher<? extends EncodedMessage> encode(@Nonnull MessageEncodeContext context) {
        return Mono.empty();
    }
}

