/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.StatusCode;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.User;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;
import org.hswebframework.web.authorization.simple.SimpleUser;
import org.hswebframework.web.logging.events.AccessLoggerBeforeEvent;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.trace.TraceHolder;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class TraceWebFilter
implements WebFilter,
Ordered {
    static AttributeKey<String> action = AttributeKey.stringKey((String)"request.action");
    static AttributeKey<String> ip = AttributeKey.stringKey((String)"request.ip");
    static AttributeKey<String> userId = AttributeKey.stringKey((String)"user.id");
    static AttributeKey<String> username = AttributeKey.stringKey((String)"user.username");
    static AttributeKey<String> userName = AttributeKey.stringKey((String)"user.name");
    public static final Authentication anonymous;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String spanName = exchange.getRequest().getMethodValue() + ":" + exchange.getRequest().getPath().value();
        return (Mono)((Mono)TraceHolder.writeContextTo((Object)exchange.getResponse().getHeaders(), HttpHeaders::set).then(chain.filter(exchange)).as((Function)MonoTracer.create((String)spanName))).as((Function)MonoTracer.createWith((Map)exchange.getRequest().getHeaders().toSingleValueMap()));
    }

    @EventListener
    public void handleAccessLogger(AccessLoggerBeforeEvent event) {
        String spanName = "/java/" + event.getLogger().getTarget().getSimpleName() + "/" + event.getLogger().getMethod().getName();
        event.transformFirst(first -> Authentication.currentReactive().defaultIfEmpty((Object)anonymous).flatMap(auth -> (Mono)first.thenReturn((Object)event.getLogger()).as((Function)MonoTracer.create((String)spanName, (span, log) -> {
            if (log.getException() != null) {
                span.recordException(log.getException());
                span.setStatus(StatusCode.ERROR);
            }
            span.setAttribute(action, (Object)log.getAction());
            span.setAttribute(ip, (Object)log.getIp());
            span.setAttribute(userId, (Object)auth.getUser().getId());
            span.setAttribute(username, (Object)auth.getUser().getUsername());
            span.setAttribute(userName, (Object)auth.getUser().getName());
            log.getContext().put("traceId", span.getSpanContext().getTraceId());
        }, builder -> builder.setStartTimestamp(event.getLogger().getRequestTime(), TimeUnit.MILLISECONDS)))));
    }

    public int getOrder() {
        return -2147483548;
    }

    static {
        SimpleAuthentication auth = new SimpleAuthentication();
        auth.setUser((User)SimpleUser.builder().id("anonymous").userType("none").name("anonymous").username("anonymous").build());
        anonymous = auth;
    }
}

