/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.reactorql;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.reactorql.ReactorQL;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorQLFactoryBean
implements FactoryBean<Object>,
InitializingBean,
Ordered {
    private Class<?> target;
    private Object proxy;
    private static final ParameterNameDiscoverer nameDiscoverer = new LocalVariableTableParameterNameDiscoverer();

    public Object getObject() {
        return this.proxy;
    }

    public Class<?> getObjectType() {
        return this.target;
    }

    public void afterPropertiesSet() {
        ConcurrentHashMap cache = new ConcurrentHashMap();
        this.proxy = Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), new Class[]{this.target}, (proxy, method, args) -> cache.computeIfAbsent(method, mtd -> this.createInvoker(this.target, (Method)mtd, mtd.getAnnotation(ReactorQL.class))).apply(args));
    }

    private Function<Object[], Object> createInvoker(Class<?> type, Method method, ReactorQL ql) {
        if (method.isDefault() || ql == null) {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)constructor.newInstance(type);
            MethodHandle handle = lookup.in(type).unreflectSpecial(method, type).bindTo(this.proxy);
            return args -> {
                try {
                    return handle.invokeWithArguments(args);
                }
                catch (Throwable e) {
                    return Mono.error((Throwable)e);
                }
            };
        }
        ResolvableType returnType = ResolvableType.forMethodReturnType((Method)method);
        if (returnType.toClass() != Mono.class && returnType.toClass() != Flux.class) {
            throw new UnsupportedOperationException("\u65b9\u6cd5\u8fd4\u56de\u503c\u5fc5\u987b\u4e3aMono\u6216\u8005Flux");
        }
        Class genericType = returnType.getGeneric(new int[]{0}).toClass();
        Function<Object, Object> mapper = genericType == Map.class || genericType == Object.class ? Function.identity() : map -> FastBeanCopier.copy((Object)map, (Class)genericType, (String[])new String[0]);
        Function<Flux, Publisher> resultMapper = returnType.resolve() == Mono.class ? flux -> flux.take(1L).singleOrEmpty() : flux -> flux;
        String[] names = nameDiscoverer.getParameterNames(method);
        try {
            org.jetlinks.reactor.ql.ReactorQL reactorQL = org.jetlinks.reactor.ql.ReactorQL.builder().sql(ql.value()).build();
            return args -> {
                HashMap<String, Object> argsMap = new HashMap<String, Object>();
                ReactorQLContext context = ReactorQLContext.ofDatasource(name -> {
                    if (((Object[])args).length == 0) {
                        return Flux.just((Object)1);
                    }
                    if (((Object[])args).length == 1) {
                        return this.convertToFlux(args[0]);
                    }
                    return this.convertToFlux(argsMap.get(name));
                });
                for (int i = 0; i < ((Object[])args).length; ++i) {
                    String indexName = "arg" + i;
                    String name2 = names == null ? indexName : names[i];
                    context.bind(i, args[i]);
                    context.bind(name2, args[i]);
                    context.bind(indexName, args[i]);
                    argsMap.put(names == null ? indexName : names[i], args[i]);
                    argsMap.put(indexName, args[i]);
                }
                return reactorQL.start(context).map(record -> mapper.apply(record.asMap())).as(resultMapper);
            };
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("create ReactorQL method [" + method + "] error,sql:\n" + String.join((CharSequence)" ", ql.value()), e);
        }
    }

    protected Flux<Object> convertToFlux(Object arg) {
        if (arg == null) {
            return Flux.empty();
        }
        if (arg instanceof Publisher) {
            return Flux.from((Publisher)((Publisher)arg));
        }
        if (arg instanceof Iterable) {
            return Flux.fromIterable((Iterable)((Iterable)arg));
        }
        if (arg instanceof Object[]) {
            return Flux.fromArray((Object[])((Object[])arg));
        }
        return Flux.just((Object)arg);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Class<?> getTarget() {
        return this.target;
    }

    public void setTarget(Class<?> target) {
        this.target = target;
    }
}

