/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;

@JsonDeserialize(using=IntervalJSONDeserializer.class)
@JSONType(deserializer=IntervalJSONDeserializer.class)
public class Interval {
    public static final String year = "y";
    public static final String quarter = "q";
    public static final String month = "M";
    public static final String weeks = "w";
    public static final String days = "d";
    public static final String hours = "h";
    public static final String minutes = "m";
    public static final String seconds = "s";
    private BigDecimal number;
    private String expression;

    public boolean isFixed() {
        return this.expression.equalsIgnoreCase(hours) || this.expression.equals(minutes) || this.expression.equals(seconds);
    }

    public boolean isCalendar() {
        return this.expression.equals(days) || this.expression.equals(month) || this.expression.equals(year);
    }

    public String toString() {
        return this.number + this.expression;
    }

    public static Interval ofSeconds(int seconds) {
        return Interval.of(seconds, seconds);
    }

    public static Interval ofDays(int days) {
        return Interval.of(days, days);
    }

    public static Interval ofHours(int hours) {
        return Interval.of(hours, hours);
    }

    public static Interval ofMonth(int month) {
        return Interval.of(month, month);
    }

    public static Interval of(int month, String expression) {
        return new Interval(new BigDecimal(month), expression);
    }

    public static Interval of(String expr) {
        char[] chars = expr.toCharArray();
        int numIndex = 0;
        for (char c : expr.toCharArray()) {
            if (c == '-' || c == '.' || c >= '0' && c <= '9') {
                ++numIndex;
                continue;
            }
            BigDecimal val = new BigDecimal(chars, 0, numIndex);
            return new Interval(val, expr.substring(numIndex));
        }
        throw new IllegalArgumentException("can not parse interval expression:" + expr);
    }

    public String getDefaultFormat() {
        switch (this.getExpression()) {
            case "y": {
                return "yyyy";
            }
            case "q": 
            case "M": {
                return "yyyy-MM";
            }
            case "d": {
                return "yyyy-MM-dd";
            }
            case "h": {
                return "MM-dd HH";
            }
            case "m": {
                return "MM-dd HH:mm";
            }
            case "s": {
                return "HH:mm:ss";
            }
        }
        return "yyyy-MM-dd HH:mm:ss";
    }

    public BigDecimal getNumber() {
        return this.number;
    }

    public String getExpression() {
        return this.expression;
    }

    public Interval(BigDecimal number, String expression) {
        this.number = number;
        this.expression = expression;
    }

    public Interval() {
    }

    public static class IntervalJSONDeserializer
    extends JsonDeserializer<Interval> {
        public Interval deserialize(JsonParser jp, DeserializationContext ctxt) {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String currentName = jp.currentName();
            Object currentValue = jp.getCurrentValue();
            if (currentName == null || currentValue == null) {
                return null;
            }
            return Interval.of(node.textValue());
        }
    }
}

