package org.jetlinks.community.auth.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hswebframework.web.authorization.annotation.*;
import org.springframework.web.bind.annotation.*;
import reactor.core.publisher.Flux;


/**
 * 资产相关
 *
 * @author yhc
 * @since 1.0
 */
@RestController
@RequestMapping("/asset")
@Authorize
@Resource(id = "asset", name = "资产相关", group = "asset")
@Tag(name = "资产相关")
@AllArgsConstructor
public class AssetController  {


    @GetMapping("/types")
    @Operation(summary = "根据菜单获取对应的资产类型")
    public Flux<AssetTypeView> getAssetTypeByMenuGrant() {
        // 社区版本目前不支持数据权限控制
        return Flux.just
            (AssetTypeView.of("sys", "系统资源"),
                AssetTypeView.of("org", "组织资源"),
                AssetTypeView.of("warehouse", "库房资源")
            );
        //return Flux.empty();
    }

    @Getter
    @Setter
    @AllArgsConstructor(staticName = "of")
    @NoArgsConstructor
    public static class AssetTypeView {
        private String id;
        private String name;
    }

}