/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.utils;

import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.defaults.service.DefaultDimensionUserService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DimensionUserBindUtils {
    public static Mono<Void> bindUser(DefaultDimensionUserService dimensionUserService, Collection<String> userIdList, String dimensionType, Collection<String> dimensionIdList, boolean removeOldBind) {
        Mono before = Mono.empty();
        if (removeOldBind) {
            before = ((ReactiveDelete)((ReactiveDelete)((ReactiveDelete)dimensionUserService.createDelete().where()).in(DimensionUserEntity::getUserId, userIdList)).and(DimensionUserEntity::getDimensionTypeId, (Object)dimensionType)).execute().then();
        }
        if (CollectionUtils.isEmpty(dimensionIdList)) {
            return before;
        }
        return before.then(((Mono)Flux.fromIterable(userIdList).flatMap(userId -> Flux.fromIterable((Iterable)dimensionIdList).map(dimensionId -> DimensionUserBindUtils.createEntity(dimensionType, dimensionId, userId))).as(arg_0 -> ((DefaultDimensionUserService)dimensionUserService).save(arg_0))).then());
    }

    public static Mono<Void> unbindUser(DefaultDimensionUserService dimensionUserService, Collection<String> userIdList, String dimensionType, Collection<String> dimensionIdList) {
        return ((ReactiveDelete)((ReactiveDelete)((ReactiveDelete)((ReactiveDelete)dimensionUserService.createDelete().where()).in(DimensionUserEntity::getUserId, userIdList)).and(DimensionUserEntity::getDimensionTypeId, (Object)dimensionType)).when(CollectionUtils.isNotEmpty(dimensionIdList), delete -> {
            ReactiveDelete cfr_ignored_0 = (ReactiveDelete)delete.in(DimensionUserEntity::getDimensionId, dimensionIdList);
        })).execute().then();
    }

    private static DimensionUserEntity createEntity(String dimensionType, String dimensionId, String userId) {
        DimensionUserEntity entity = new DimensionUserEntity();
        entity.setUserId(userId);
        entity.setUserName(userId);
        entity.setDimensionName(dimensionId);
        entity.setDimensionTypeId(dimensionType);
        entity.setDimensionId(dimensionId);
        entity.generateId();
        return entity;
    }
}

