/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;

@Table(name="s_third_party_user_bind", indexes={@Index(name="idx_thpub_user_id", columnList="user_id"), @Index(name="idx_thpub_tpu_tpu", columnList="type,provider,user_id")})
@Comment(value="\u7b2c\u4e09\u65b9\u7528\u6237\u7ed1\u5b9a\u4fe1\u606f\u8868")
@EnableEntityEvent
public class ThirdPartyUserBindEntity
extends GenericEntity<String> {
    @Schema(description="\u7ed1\u5b9a\u7c7b\u578b,\u5982: \u5fae\u4fe1,\u9489\u9489")
    @Column(nullable=false, length=64, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String type;
    @Schema(description="\u7b2c\u4e09\u65b9\u6807\u8bc6,\u5982: \u5fae\u4fe1\u4f01\u4e1aA,\u4f01\u4e1aB")
    @Column(nullable=false, length=64, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String provider;
    @Schema(description="\u7b2c\u4e09\u65b9\u540d\u79f0")
    @Column(nullable=false, length=64)
    private String providerName;
    @Schema(description="\u7b2c\u4e09\u65b9\u7528\u6237ID")
    @Column(nullable=false, length=64, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String thirdPartyUserId;
    @Schema(description="\u5e73\u53f0\u7528\u6237ID")
    @Column(nullable=false, length=64, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String userId;
    @Schema(description="\u7ed1\u5b9a\u65f6\u95f4")
    @Column(nullable=false, updatable=false)
    @DefaultValue(generator="current_time")
    private Long bindTime;
    @Column
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    @Schema(description="\u5176\u4ed6\u914d\u7f6e\u4fe1\u606f")
    private Map<String, Object> others;

    public void generateId() {
        this.setId(ThirdPartyUserBindEntity.generateId(this.type, this.provider, this.thirdPartyUserId));
    }

    public static String generateId(String ... arr) {
        return DigestUtils.md5Hex((String)String.join((CharSequence)"|", arr));
    }

    public String getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getThirdPartyUserId() {
        return this.thirdPartyUserId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getBindTime() {
        return this.bindTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getOthers() {
        return this.others;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setThirdPartyUserId(String thirdPartyUserId) {
        this.thirdPartyUserId = thirdPartyUserId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBindTime(Long bindTime) {
        this.bindTime = bindTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setOthers(Map<String, Object> others) {
        this.others = others;
    }
}

