/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.constraints.Length;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericTreeSortSupportEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.community.auth.entity.MenuButtonInfo;
import org.jetlinks.community.auth.entity.PermissionInfo;

@Table(name="s_menu", indexes={@Index(name="idx_menu_path", columnList="path")})
@Comment(value="\u83dc\u5355\u4fe1\u606f\u8868")
@EnableEntityEvent
public class MenuEntity
extends GenericTreeSortSupportEntity<String>
implements RecordCreationEntity {
    @Schema(description="\u83dc\u5355\u6240\u6709\u8005")
    @Column(length=64)
    private String owner;
    @Schema(description="\u540d\u79f0")
    @Column(length=32, nullable=false)
    @Length(max=32, min=1, groups={CreateGroup.class})
    private @Length(max=32, min=1, groups={CreateGroup.class}) String name;
    @Schema(description="\u7f16\u7801")
    @Column(length=32)
    @Length(max=32, groups={CreateGroup.class})
    private @Length(max=32, groups={CreateGroup.class}) String code;
    @Schema(description="\u6240\u5c5e\u5e94\u7528")
    @Column(length=64)
    @Length(max=64, groups={CreateGroup.class})
    private @Length(max=64, groups={CreateGroup.class}) String application;
    @Column
    @ColumnType(jdbcType=JDBCType.CLOB)
    @Schema(description="\u63cf\u8ff0")
    private String describe;
    @Column(length=512)
    @Schema(description="URL,\u8def\u7531")
    @Length(max=512, groups={CreateGroup.class})
    private @Length(max=512, groups={CreateGroup.class}) String url;
    @Column(length=256)
    @Schema(description="\u56fe\u6807")
    @Length(max=256, groups={CreateGroup.class})
    private @Length(max=256, groups={CreateGroup.class}) String icon;
    @Column
    @ColumnType(jdbcType=JDBCType.SMALLINT)
    @Schema(description="\u72b6\u6001,0\u4e3a\u7981\u7528,1\u4e3a\u542f\u7528")
    @DefaultValue(value="1")
    private Byte status;
    @Schema(description="\u7ed1\u5b9a\u6743\u9650\u4fe1\u606f")
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    private List<PermissionInfo> permissions;
    @Schema(description="\u6309\u94ae\u5b9a\u4e49\u4fe1\u606f")
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    private List<MenuButtonInfo> buttons;
    @Schema(description="\u5176\u4ed6\u914d\u7f6e\u4fe1\u606f")
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    private Map<String, Object> options;
    @Schema(description="\u5b50\u83dc\u5355")
    private List<MenuEntity> children;
    @Column(name="creator_id", updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorId;
    @Column(name="create_time", updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;

    public boolean isSupportDataAccess() {
        return false;
    }

    public MenuEntity copy(Predicate<MenuButtonInfo> buttonPredicate) {
        MenuEntity entity = (MenuEntity)((Object)this.copyTo((Object)new MenuEntity(), new String[0]));
        if (CollectionUtils.isEmpty(entity.getButtons())) {
            return entity;
        }
        entity.setButtons(entity.getButtons().stream().filter(buttonPredicate).collect(Collectors.toList()));
        return entity;
    }

    public boolean hasPermission(BiPredicate<String, Collection<String>> predicate) {
        if (CollectionUtils.isEmpty(this.permissions) && CollectionUtils.isEmpty(this.buttons)) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(this.permissions)) {
            for (PermissionInfo permission : this.permissions) {
                if (predicate.test(permission.getPermission(), permission.getActions())) continue;
                return false;
            }
            return true;
        }
        if (CollectionUtils.isNotEmpty(this.buttons)) {
            for (MenuButtonInfo button : this.buttons) {
                if (!button.hasPermission(predicate)) continue;
                return true;
            }
        }
        return false;
    }

    public Optional<MenuButtonInfo> getButton(String id) {
        if (this.buttons == null) {
            return Optional.empty();
        }
        return this.buttons.stream().filter(button -> Objects.equals(button.getId(), id)).findAny();
    }

    public MenuEntity ofApp(String appId, String owner) {
        this.setId(null);
        this.setParentId(null);
        this.setOwner(owner);
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getApplication() {
        return this.application;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getUrl() {
        return this.url;
    }

    public String getIcon() {
        return this.icon;
    }

    public Byte getStatus() {
        return this.status;
    }

    public List<PermissionInfo> getPermissions() {
        return this.permissions;
    }

    public List<MenuButtonInfo> getButtons() {
        return this.buttons;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public List<MenuEntity> getChildren() {
        return this.children;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public void setPermissions(List<PermissionInfo> permissions) {
        this.permissions = permissions;
    }

    public void setButtons(List<MenuButtonInfo> buttons) {
        this.buttons = buttons;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setChildren(List<MenuEntity> children) {
        this.children = children;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }
}

