/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.captcha;

import com.wf.captcha.SpecCaptcha;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.events.AuthorizationDecodeEvent;
import org.hswebframework.web.exception.ValidationException;
import org.jetlinks.community.auth.captcha.CaptchaProperties;
import org.reactivestreams.Publisher;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@Authorize(ignore=true)
@RequestMapping(value={"/authorize/captcha"})
@Tag(name="\u9a8c\u8bc1\u7801\u63a5\u53e3")
public class CaptchaController {
    private final CaptchaProperties properties;
    private final ReactiveRedisOperations<String, String> redis;

    @GetMapping(value={"/config"})
    @Operation(summary="\u83b7\u53d6\u9a8c\u8bc1\u7801\u76f8\u5173\u914d\u7f6e\u4fe1\u606f")
    public Mono<CaptchaConfig> createCaptcha() {
        CaptchaConfig captchaConfig = new CaptchaConfig();
        captchaConfig.setEnabled(this.properties.isEnabled());
        captchaConfig.setType(this.properties.getType().name());
        return Mono.just((Object)captchaConfig);
    }

    @GetMapping(value={"/image"})
    @Operation(summary="\u83b7\u53d6\u9a8c\u8bc1\u7801\u56fe\u7247")
    public Mono<CaptchaInfo> createCaptcha(@RequestParam(defaultValue="130") @Parameter(description="\u5bbd\u5ea6,\u9ed8\u8ba4130px") int width, @RequestParam(defaultValue="40") @Parameter(description="\u9ad8\u5ea6,\u9ed8\u8ba440px") int height) {
        if (!this.properties.isEnabled()) {
            return Mono.empty();
        }
        SpecCaptcha captcha = new SpecCaptcha(width, height, 4);
        captcha.setCharType(1);
        String base64 = captcha.toBase64();
        String key = UUID.randomUUID().toString();
        return this.redis.opsForValue().set((Object)("captcha:" + key), (Object)captcha.text(), this.properties.getTtl()).thenReturn((Object)new CaptchaInfo(key, base64));
    }

    @EventListener
    public void handleAuthEvent(AuthorizationDecodeEvent event) {
        if (!this.properties.isEnabled()) {
            return;
        }
        String key = event.getParameter("verifyKey").map(String::valueOf).orElseThrow(() -> new ValidationException("\u9a8c\u8bc1\u7801\u9519\u8bef"));
        String code = event.getParameter("verifyCode").map(String::valueOf).orElseThrow(() -> new ValidationException("\u9a8c\u8bc1\u7801\u9519\u8bef"));
        String redisKey = "captcha:" + key;
        event.async((Publisher)this.redis.opsForValue().get((Object)redisKey).map(code::equalsIgnoreCase).defaultIfEmpty((Object)false).flatMap(checked -> this.redis.delete((Object[])new String[]{redisKey}).then(checked != false ? Mono.empty() : Mono.error((Throwable)new ValidationException("\u9a8c\u8bc1\u7801\u9519\u8bef")))));
    }

    public CaptchaController(CaptchaProperties properties, ReactiveRedisOperations<String, String> redis) {
        this.properties = properties;
        this.redis = redis;
    }

    public static class CaptchaConfig {
        @Schema(description="\u662f\u5426\u5f00\u542f\u9a8c\u8bc1\u7801")
        private boolean enabled;
        @Schema(description="\u9a8c\u8bc1\u7801\u7c7b\u578b")
        private String type;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getType() {
            return this.type;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setType(String type) {
            this.type = type;
        }

        public CaptchaConfig(boolean enabled, String type) {
            this.enabled = enabled;
            this.type = type;
        }

        public CaptchaConfig() {
        }
    }

    public static class CaptchaInfo {
        @Schema(description="\u9a8c\u8bc1\u7801\u6807\u8bc6,\u767b\u5f55\u65f6\u9700\u8981\u5728\u53c2\u6570[verifyKey]\u4f20\u5165\u6b64\u503c.")
        private String key;
        @Schema(description="\u56fe\u7247Base64,\u4ee5data:image/png;base64,\u5f00\u5934")
        private String base64;

        public String getKey() {
            return this.key;
        }

        public String getBase64() {
            return this.base64;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setBase64(String base64) {
            this.base64 = base64;
        }

        public CaptchaInfo(String key, String base64) {
            this.key = key;
            this.base64 = base64;
        }

        public CaptchaInfo() {
        }
    }
}

