(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define('element/locale/bn', ['exports'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports);
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports);
    global.ELEMENT.lang = global.ELEMENT.lang || {}; 
    global.ELEMENT.lang.bn = mod.exports;
  }
})(this, function (exports) {
  'use strict';

  exports.__esModule = true;
  exports.default = {
    el: {
      colorpicker: {
        confirm: 'নিশ্চিত',
        clear: 'খালি'
      },
      datepicker: {
        now: 'এখন',
        today: 'আজকাল',
        cancel: 'বাতিল করুন',
        clear: 'খালি',
        confirm: 'নিশ্চিত',
        selectDate: 'তারিখ নির্বাচন করুন',
        selectTime: 'নির্বাচনের সময়কাল',
        startDate: 'শুরুর তারিখ',
        startTime: 'শুরুর সময়',
        endDate: 'শেষ তারিখ',
        endTime: 'শেষ সময়',
        prevYear: 'গত বছর',
        nextYear: 'আগামী বছর',
        prevMonth: 'গত মাসে',
        nextMonth: 'পরের মাসে',
        year: 'বছর',
        month1: 'জানুয়ারি',
        month2: 'ফেব্রুয়ারি',
        month3: 'মার্চ',
        month4: 'এপ্রিল',
        month5: 'মে',
        month6: 'জুন',
        month7: 'জুলাই',
        month8: 'আগস্ট',
        month9: 'সেপ্টেম্বর',
        month10: 'অক্টোবর',
        month11: 'নভেম্বর',
        month12: 'ডিসেম্বর',
        // week: '周次',
        weeks: {
          sun: 'রবিবার',
          mon: 'সোমবারে',
          tue: 'মঙ্গলবার',
          wed: 'বুধবার',
          thu: 'বৃহস্পতিবার',
          fri: 'শুক্রবার',
          sat: 'শনিবার'
        },
        months: {
          jan: 'জানুয়ারি',
          feb: 'ফেব্রুয়ারি',
          mar: 'মার্চ',
          apr: 'এপ্রিল',
          may: 'মে',
          jun: 'জুন',
          jul: 'জুলাই',
          aug: 'আগস্ট',
          sep: 'সেপ্টেম্বর',
          oct: 'অক্টোবর',
          nov: 'নভেম্বর',
          dec: 'ডিসেম্বর'
        }
      },
      select: {
        loading: 'লোড হচ্ছে',
        noMatch: 'কোন মিল তথ্য',
        noData: 'কোন তথ্য নেই',
        placeholder: 'পছন্দ কর'
      },
      cascader: {
        noMatch: 'কোন মিল তথ্য',
        loading: 'লোড হচ্ছে',
        placeholder: 'পছন্দ কর',
        noData: 'কোন তথ্য নেই'
      },
      pagination: {
        goto: 'যাও',
        pagesize: 'প্রবন্ধ/পৃষ্ঠা',
        total: 'সর্বমোট {total} ফালা',
        pageClassifier: 'পাতা'
      },
      messagebox: {
        title: 'ইঙ্গিত',
        confirm: 'নিশ্চিত',
        cancel: 'বাতিল করুন',
        error: 'প্রবেশ করা তথ্য অবৈধ!'
      },
      upload: {
        deleteTip: 'অনুসারে delete মুছে ফেলা',
        delete: 'মুছে ফেলা',
        preview: 'ভিউ ইমেজ',
        continue: 'আপলোড চালিয়ে যান'
      },
      table: {
        emptyText: 'কোন তথ্য নেই',
        confirmFilter: 'ছাঁকনি',
        resetFilter: 'রিসেট',
        clearFilter: 'সব',
        sumText: 'মোট'
      },
      tree: {
        emptyText: 'কোন তথ্য নেই'
      },
      transfer: {
        noMatch: 'কোন মিল তথ্য',
        noData: 'কোন তথ্য নেই',
        titles: ['তালিকা 1', 'তালিকা 2'],
        filterPlaceholder: 'অনুসন্ধান বিষয়বস্তু লিখুন',
        noCheckedFormat: 'মোট {total} আইটেম',
        hasCheckedFormat: 'নির্বাচিত {checked}/{total}  আইটেম'
      },
      image: {
        error: 'লোড করতে ব্যর্থ'
      },
      pageHeader: {
        title: 'প্রত্যাবর্তন'
      },
      popconfirm: {
        confirmButtonText: 'নিশ্চিত',
        cancelButtonText: 'বাতিল করুন'
      },
      empty: {
        description: 'কোন তথ্য নেই'
      }
    }
  };
});