package com.artfess.easyExcel.service.impl;


import com.alibaba.fastjson.JSON;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.util.AppUtil;
import com.artfess.easyExcel.service.ExcelDynamicSelect;
import com.artfess.easyExcel.vo.DictionaryDetailVo;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 获取字典name下拉
 *
 * @Author : min.wu
 * @Date: 2023/12/15 17:10
 */
public class DictNameServiceImpl implements ExcelDynamicSelect {

    private static final CacheSetting cacheSetting = CacheSetting.buildDefault("字典缓存");

    @Override
    public String[] getSource(String dictKey) {
        CacheManager cacheManager = AppUtil.getBean(CacheManager.class);
        ICache cache = cacheManager.getCache("", cacheSetting);
        String key = CacheKeyConst.SYS_DICTIONARY_KEY + ":" + dictKey.toUpperCase() + ":";
        Object o = cache.get(key);
        if(null == o) {
            return new String[]{};
        }
        List<DictionaryDetailVo> dictionaryDetails = JSON.parseArray(o.toString(), DictionaryDetailVo.class);
        if(CollectionUtils.isEmpty(dictionaryDetails)) {
            return new String[]{};
        }
        List<String> collect = dictionaryDetails.stream().map(dictionaryDetailVo -> dictionaryDetailVo.getName()).collect(Collectors.toList());
        return collect.toArray(new String[collect.size()]);
    }
}
