import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '联系人',
            prop: 'companyContact',
            type: 'input',
            value: ''
        },
        {
            title: '联系电话',
            prop: 'contactTel',
            type: 'input',
            value: ''
        },
        {
            title: '注册日期',
            prop: 'companyRegdate',
            type: 'date',
            dateOption: {
                type: 'daterange',
                format: 'YYYY-MM-DD',
                valueFormat: 'YYYY-MM-DD'
            },
            span: 6,
            value: []
        },
        {
            title: '签署状态',
            prop: 'auditStatus',
            type: 'select',
            multiple: true,
            options: getDictionaryByCode('qyxyqszt'),
            value: []
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'evaluationSystemName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '周期类型',
            prop: 'enableOrFreeze',
            type: 'select',
            multiple: true,
            options: [
                { name: '禁用', value: '0' },
                { name: '启用', value: '1' }
            ],
            value: [],
            span: 4
        },
        {
            title: '状态',
            prop: 'enableOrFreeze',
            type: 'select',
            multiple: true,
            options: [
                { name: '禁用', value: '0' },
                { name: '启用', value: '1' }
            ],
            value: [],
            span: 4
        },
        {
            title: '考核周期',
            prop: 'creationTime',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '组织考核企业',
            prop: 'gfmc',
            minWidth: 120,
            sortable: true
        },
        {
            title: '评价体系',
            prop: 'pjtx',
            minWidth: 120,
            sortable: true
        },
        {
            title: '考核年度',
            prop: 'khnd',
            minWidth: 120,
            sortable: true
        },
        {
            title: '周期名称',
            prop: 'zqmc',
            minWidth: 120,
            sortable: true
        },
        {
            title: '周期类型',
            prop: 'zqlx',
            minWidth: 120,
            sortable: true
        },
        {
            title: '考核周期',
            prop: 'khzq',
            minWidth: 200,
            sortable: true
        },
        {
            title: '考核得分',
            prop: 'khdf',
            minWidth: 120,
            sortable: true
        },
        {
            title: '考核评级',
            prop: 'khpj',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '状态',
            prop: 'zt',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
