import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '联系人',
            prop: 'companyContact',
            type: 'input',
            value: ''
        },
        {
            title: '联系电话',
            prop: 'contactTel',
            type: 'input',
            value: ''
        },
        {
            title: '注册日期',
            prop: 'companyRegdate',
            type: 'date',
            dateOption: {
                type: 'daterange',
                format: 'YYYY-MM-DD',
                valueFormat: 'YYYY-MM-DD'
            },
            span: 6,
            value: []
        },
        {
            title: '签署状态',
            prop: 'auditStatus',
            type: 'select',
            multiple: true,
            options: getDictionaryByCode('qyxyqszt'),
            value: []
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'supplierName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '考核类型',
            prop: 'assessmentType',
            type: 'select',
            options: [
                { name: '年度考核', value: '3' },
                { name: '季度考核', value: '2' },
                { name: '月度考核', value: '1' }
            ],
            value: '',
            span: 4
        },
        {
            title: '状态',
            prop: 'status',
            type: 'select',
            multiple: true,
            options: [
                { name: '禁用', value: '0' },
                { name: '启用', value: '1' }
            ],
            value: [],
            span: 4
        },
        {
            title: '考核周期',
            prop: 'creationTime',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供方编码',
            prop: 'supplierNumber',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供方名称',
            prop: 'supplierName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '企业编码',
            prop: 'enterpriseCode',
            minWidth: 120,
            sortable: true
        },
        {
            title: '企业名称',
            prop: 'enterpriseName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '评价体系名称',
            prop: 'valuationConfigurationName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '考核年度',
            prop: 'assessmentYear',
            minWidth: 120,
            render: true,
            sortable: true
        },
        {
            title: '考核类型',
            prop: 'assessmentType',
            minWidth: 120,
            render: true,
            sortable: true
        },
        {
            title: '考核周期',
            prop: 'assessment',
            minWidth: 120,
            render: true,
            sortable: true
        },
        {
            title: '总分值',
            prop: 'totalScore',
            minWidth: 120,
            sortable: true
        },
        {
            title: '考核得分',
            prop: 'operationScore',
            minWidth: 120,
            sortable: true
        },
        {
            title: '考核评级',
            prop: 'level',
            minWidth: 120,
            sortable: true
        },
        {
            title: '评价结论',
            prop: 'assessmentResult',
            minWidth: 120,
            sortable: true
        },
        
        {
            title: '状态',
            prop: 'status',
            minWidth: 120,
            sortable: true,
            render: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
