/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.PinyinUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.sysConfig.persistence.dao.SysTagDao;
import com.artfess.sysConfig.persistence.manager.SysTagManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysTag;
import com.artfess.sysConfig.persistence.model.SysType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysTagManager")
public class SysTagManagerImpl
extends BaseManagerImpl<SysTagDao, SysTag>
implements SysTagManager {
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    IdGenerator idGenerator;

    @Override
    @Transactional
    public void removeByTypeId(String typeId) {
        if (StringUtil.isNotEmpty((String)typeId)) {
            List<SysType> sysTypes = this.sysTypeManager.getChildByTypeId(typeId);
            List<String> ids = sysTypes.stream().map(item -> item.getId()).collect(Collectors.toList());
            ids.add(typeId);
            this.sysTypeManager.removeByIds(ids);
            ids.forEach(id -> {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"type_id_", id);
                ((SysTagDao)this.baseMapper).delete((Wrapper)wrapper);
            });
        }
    }

    @Override
    public List<SysTag> getTagsByTypeId(String typeId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"type_id_", (Object)typeId);
        return ((SysTagDao)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public Integer countByName(String key, String typeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"name_", (Object)key)).eq((Object)"type_id_", (Object)typeId);
        return ((SysTagDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
    }

    @Override
    public Integer countByKey(String sysTagKey, String typeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"key_", (Object)sysTagKey)).eq((Object)"type_id_", (Object)typeId);
        return ((SysTagDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
    }

    @Override
    public void createWithCheck(SysTag sysTag) throws Exception {
        SysType sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("TAG", sysTag.getTypeKey());
        if (BeanUtils.isEmpty((Object)((Object)sysType))) {
            throw new RuntimeException("[" + sysTag.getTypeKey() + "]\u4e0d\u5b58\u5728");
        }
        if (this.countByName(sysTag.getName(), sysType.getId()) > 0) {
            throw new RuntimeException("[" + sysTag.getName() + "]\u5df2\u5b58\u5728");
        }
        if (this.countByKey(sysTag.getKey(), sysType.getId()) > 0) {
            throw new RuntimeException("\u6807\u7b7ekey\uff1a[" + sysTag.getKey() + "]\u5df2\u5b58\u5728");
        }
        sysTag.setTypeId(sysType.getId());
        if (StringUtil.isEmpty((String)sysTag.getKey())) {
            sysTag.setKey(PinyinUtil.getPinyinToLowerCase((String)sysTag.getName()) + DateUtil.getCurrentTimeInMillis());
        }
        this.create((Model)sysTag);
    }

    @Override
    @Transactional
    public void importFile(String unZipFilePath, String typeId) {
        List<SysTag> primitive = this.getTagsByTypeId(typeId);
        try {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "sysTags.json"));
            List list = (List)JsonUtil.toBean((String)json, List.class);
            ArrayList<SysTag> newTags = new ArrayList<SysTag>();
            for (Object o : list) {
                SysTag sysTag = (SysTag)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysTag.class));
                sysTag.setTypeId(typeId);
                sysTag.setId(this.idGenerator.getSuid());
                sysTag.setTenantId(null);
                newTags.add(sysTag);
            }
            if (BeanUtils.isEmpty(primitive)) {
                for (SysTag newTag : newTags) {
                    this.create((Model)newTag);
                }
            } else {
                for (SysTag newTag : newTags) {
                    if (this.isSysTagExists(newTag, primitive)) continue;
                    this.create((Model)newTag);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    private boolean isSysTagExists(SysTag sysTag, List<SysTag> list) {
        for (SysTag tag : list) {
            if (!sysTag.getName().equals(tag.getName())) continue;
            return true;
        }
        return false;
    }
}

