/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataShare.manager.BizShareFilesManager;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/dataShare/shareFiles/v1/"})
@Api(tags={"\u6570\u636e\u8d44\u6e90--\u6587\u4ef6\u5171\u4eab\u4fe1\u606f"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizShareFilesController
extends BaseController<BizShareFilesManager, BizShareFiles> {
    @PostMapping(value={"saveInfo"})
    @ApiOperation(value="\u4fdd\u5b58\u6587\u4ef6\u914d\u7f6e\u4fe1\u606f")
    public CommonResult<String> saveInfo(@RequestBody BizShareFiles file) {
        boolean result = ((BizShareFilesManager)this.baseService).saveInfo(file);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizShareFiles> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizShareFiles> queryFilter) {
        PageList<BizShareFiles> pageList = ((BizShareFilesManager)this.baseService).queryPage(queryFilter);
        return pageList;
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizShareFiles getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        BizShareFiles files = ((BizShareFilesManager)this.baseService).getInfo(id);
        return files;
    }

    @PutMapping(value={"updateInfo"})
    @ApiOperation(value="\u4fee\u6539\u6587\u4ef6\u914d\u7f6e\u4fe1\u606f")
    public CommonResult<String> updateInfo(@RequestBody BizShareFiles file) {
        boolean result = ((BizShareFilesManager)this.baseService).updateInfo(file);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"uploadFile"})
    @ApiOperation(value="\u8d44\u6e90\u6587\u4ef6\u4e0a\u4f20")
    public CommonResult<String> uploadFile(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="id") String id) {
        boolean result = ((BizShareFilesManager)this.baseService).uploadFile(response, request, id);
        return result ? CommonResult.success(null, (String)"\u8d44\u6e90\u4e0a\u4f20\u6210\u529f\uff01") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @GetMapping(value={"downloadFile"})
    @ApiOperation(value="\u8d44\u6e90\u6587\u4ef6\u4e0b\u8f7d")
    public void downloadFile(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="id") String id) throws IOException {
        ((BizShareFilesManager)this.baseService).downloadFile(response, request, id);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664-\u540c\u65f6\u5220\u9664\u4e0a\u4f20\u7684\u6587\u4ef6")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((BizShareFilesManager)this.baseService).removeFilesById(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/removeBatch"})
    @ApiOperation(value="\u6279\u91cf-\u6839\u636eid\u5220\u9664-\u540c\u65f6\u5220\u9664\u4e0a\u4f20\u7684\u6587\u4ef6")
    public CommonResult<String> removeBatch(String ... ids) {
        boolean result = ((BizShareFilesManager)this.baseService).removeBatch(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"queryPageByCatalog"})
    @ApiOperation(value="\u6388\u6743\u67e5\u8be2-\u901a\u8fc7\u76ee\u5f55\u5206\u9875\u67e5\u8be2\u63a5\u53e3")
    public PageList<BizShareFiles> queryPageByCatalog(@RequestBody QueryFilter<BizShareFiles> queryFilter, @RequestParam(value="catalogId") String catalogId, @RequestParam(value="consumerId") String consumerId) {
        PageList<BizShareFiles> pageList = ((BizShareFilesManager)this.baseService).queryPageByCatalog(queryFilter, catalogId, consumerId);
        return pageList;
    }
}

