/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.job.job;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.job.model.BaseJob;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Resource;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class FlowStartJob
extends BaseJob {
    @Resource
    WorkflowFeignService workflowFeignService;

    @Override
    public void executeJob(JobExecutionContext context) throws Exception {
        String defaultAccount = "admin";
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String flowkey = jobDataMap.getString("flowkey");
        String startAccount = jobDataMap.getString("startAccount");
        if (StringUtil.isNotEmpty((String)startAccount)) {
            defaultAccount = startAccount;
        }
        ContextUtil.setCurrentUserByAccount((String)defaultAccount);
        if (BeanUtils.isEmpty((Object)flowkey)) {
            throw new BaseException("\u5b9a\u65f6\u542f\u52a8\u6d41\u7a0b\u7684\u81ea\u52a8\u4efb\u52a1\u4e2d\u5fc5\u987b\u914d\u7f6eflowkey\u6765\u6307\u5b9a\u8981\u542f\u52a8\u7684\u6d41\u7a0b.");
        }
        this.startFlow(flowkey, defaultAccount);
    }

    private void startFlow(String flowKey, String account) throws Exception {
        ObjectNode startFlowResult;
        ObjectNode startFlowParam = JsonUtil.getMapper().createObjectNode();
        startFlowParam.put("flowKey", flowKey);
        startFlowParam.put("account", account);
        if (this.workflowFeignService == null) {
            this.workflowFeignService = (WorkflowFeignService)AppUtil.getBean(WorkflowFeignService.class);
        }
        if (BeanUtils.isNotEmpty((Object)(startFlowResult = this.workflowFeignService.start(startFlowParam))) && !startFlowResult.get("state").asBoolean()) {
            String message = "\u6d41\u7a0b\u542f\u52a8\u5931\u8d25";
            if (BeanUtils.isNotEmpty((Object)startFlowResult) && BeanUtils.isNotEmpty((Object)startFlowResult.get("message"))) {
                message = message + ":" + startFlowResult.get("message").asText();
            }
            throw new BaseException(message);
        }
    }
}

