/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataShare.dao.BizShareTableFieldDao;
import com.artfess.dataShare.dataShare.manager.BizShareTableFieldManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.dataShare.dataShare.model.BizShareTableField;
import com.artfess.dataShare.dataShare.vo.ShareTableFieldVo;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizShareTableFieldManagerImpl
extends BaseManagerImpl<BizShareTableFieldDao, BizShareTableField>
implements BizShareTableFieldManager {
    @Resource
    private DatabaseContext databaseContext;
    @Resource
    private BizShareTableManager tableManager;
    @Resource
    private BizShareTableFieldManager fieldManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfoBatch(BizShareTable table) throws SQLException {
        List oldFields = ((BizShareTableFieldDao)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareTableField::getIsDele, (Object)"0")).eq(BizShareTableField::getTableId, (Object)table.getId()));
        if (BeanUtils.isNotEmpty((Object)oldFields) && oldFields.size() > 0) {
            this.fieldManager.removeByIds(oldFields.stream().filter(p -> "2".equals(p.getFieldType())).map(entity -> entity.getId()).collect(Collectors.toList()));
        }
        BizShareTable oldTable = (BizShareTable)this.tableManager.get((Serializable)((Object)table.getId()));
        List<BizShareTableField> tableFieldList = table.getTableFieldList();
        if (oldFields.size() == 0) {
            this.addManageField(tableFieldList);
        }
        HashSet fieldSet = new HashSet();
        tableFieldList.stream().map(field -> {
            if (fieldSet.contains(field.getCode())) {
                throw new ApplicationException("\u540c\u4e00\u5f20\u8868\u4e0b\u4e0d\u80fd\u521b\u5efa\u76f8\u540c\u7684\u5b57\u6bb5\uff01");
            }
            fieldSet.add(field.getCode());
            field.setIsDele("0");
            if (StringUtil.isEmpty((String)field.getIsPk())) {
                field.setIsPk("0");
            }
            field.setTableId(oldTable.getId());
            field.setResourceName(oldTable.getName());
            field.setResourceCode(oldTable.getCode());
            field.setAttrLength(BeanUtils.isEmpty((Object)field.getAttrLength()) ? 0 : field.getAttrLength());
            field.setDecimalLen(BeanUtils.isEmpty((Object)field.getDecimalLen()) ? 0 : field.getDecimalLen());
            field.setFieldCode("F_" + field.getCode());
            field.setIsCreate("0");
            field.setId(null);
            return field;
        }).collect(Collectors.toList());
        this.saveBatch(tableFieldList);
        return this.tableManager.updateById((Object)oldTable);
    }

    private void addManageField(List<BizShareTableField> fieldList) {
        BizShareTableField createBy = new BizShareTableField();
        createBy.setName("\u521b\u5efa\u4eba");
        createBy.setCode("CREATE_BY_");
        createBy.setDesc("\u521b\u5efa\u4eba");
        createBy.setDataType("varchar");
        createBy.setAttrLength(200);
        createBy.setIsPk("0");
        createBy.setIsEncrypt("0");
        createBy.setDecimalLen(0);
        createBy.setFieldType("1");
        createBy.setIsDele("0");
        createBy.setSn(100001);
        BizShareTableField createOrgId = new BizShareTableField();
        createOrgId.setName("\u521b\u5efa\u5355\u4f4d");
        createOrgId.setCode("CREATE_ORG_ID_");
        createOrgId.setDesc("\u521b\u5efa\u5355\u4f4d");
        createOrgId.setDataType("varchar");
        createOrgId.setAttrLength(200);
        createOrgId.setIsPk("0");
        createOrgId.setIsEncrypt("0");
        createOrgId.setDecimalLen(0);
        createOrgId.setFieldType("1");
        createOrgId.setIsDele("0");
        createOrgId.setSn(100002);
        BizShareTableField createTime = new BizShareTableField();
        createTime.setName("\u521b\u5efa\u65f6\u95f4");
        createTime.setCode("CREATE_TIME_");
        createTime.setDesc("\u521b\u5efa\u65f6\u95f4");
        createTime.setDataType("date");
        createTime.setAttrLength(0);
        createTime.setIsPk("0");
        createTime.setIsEncrypt("0");
        createTime.setDecimalLen(0);
        createTime.setFieldType("1");
        createTime.setIsDele("0");
        createTime.setSn(100003);
        BizShareTableField id = new BizShareTableField();
        id.setName("\u4e3b\u952e");
        id.setCode("ID_");
        id.setDesc("\u4e3b\u952e");
        id.setDataType("varchar");
        id.setAttrLength(500);
        id.setIsPk("1");
        id.setIsEncrypt("0");
        id.setDecimalLen(0);
        id.setFieldType("1");
        id.setIsDele("0");
        id.setSn(-1);
        Set set = fieldList.stream().map(entity -> entity.getCode()).collect(Collectors.toSet());
        if (!set.contains(createBy.getCode())) {
            fieldList.add(createBy);
        }
        if (!set.contains(createOrgId.getCode())) {
            fieldList.add(createOrgId);
        }
        if (!set.contains(createTime.getCode())) {
            fieldList.add(createTime);
        }
        if (!set.contains(id.getCode())) {
            fieldList.add(id);
        }
    }

    @Override
    public List<BizShareTableField> queryFieldByTable(String tableId) {
        List fieldList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareTableField::getIsDele, (Object)"0")).eq(BizShareTableField::getTableId, (Object)tableId)).orderByAsc(BizShareTableField::getSn));
        return fieldList;
    }

    @Override
    public void importFile(MultipartFile file, String tableId) throws Exception {
        BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)tableId));
        if (null == table) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u5b9e\u4f53\u8868");
        }
        String tableName = table.getTableCode();
        ExcelTool util = new ExcelTool(ShareTableFieldVo.class);
        List list = util.importExcel(file.getInputStream(), Integer.valueOf(2), Integer.valueOf(2));
        list = list.stream().filter(vo -> StringUtil.isNotEmpty((String)vo.getCode())).collect(Collectors.toList());
        List<BizShareTableField> oldFields = this.fieldManager.queryFieldByTable(tableId);
        Set<Object> manageFields = new HashSet();
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0) {
            manageFields = oldFields.stream().filter(entity -> "1".equals(entity.getFieldType())).map(entity -> entity.getCode()).collect(Collectors.toSet());
        }
        for (int i = 1; i < list.size(); ++i) {
            ShareTableFieldVo vo2 = (ShareTableFieldVo)list.get(i);
            if (manageFields.contains(vo2.getCode()) || !this.checkExistsField(tableId, vo2.getCode())) continue;
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u5b57\u6bb5(" + vo2.getName() + ")\u3011\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
        }
        List disFieldList = list.stream().map(p -> p.getCode()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < list.size()) {
            throw new BaseException("\u8868" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        for (int i = 1; i < list.size(); ++i) {
            ShareTableFieldVo vo3 = (ShareTableFieldVo)list.get(i);
            if (StringUtil.isEmpty((String)vo3.getCode()) || manageFields.contains(vo3.getCode())) continue;
            BizShareTableField field = ShareTableFieldVo.parse(vo3);
            field.setTableId(tableId);
            field.setFieldCode("F_" + field.getCode());
            if ("\u7ba1\u7406\u5b57\u6bb5".equals(vo3.getFieldType())) {
                field.setFieldType("1");
            } else if ("\u4e1a\u52a1\u5b57\u6bb5".equals(vo3.getFieldType())) {
                field.setFieldType("2");
            }
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
            field.setDecimalLen(decimalLen);
            field.setFlSql(fieldSq);
            field.setResourceName(table.getName());
            field.setResourceCode(table.getCode());
            field.setAttrLength(BeanUtils.isEmpty((Object)field.getAttrLength()) ? 0 : field.getAttrLength());
            field.setDecimalLen(BeanUtils.isEmpty((Object)field.getDecimalLen()) ? 0 : field.getDecimalLen());
            field.setIsDele("0");
            this.create((Model)field);
        }
    }

    public boolean checkExistsField(String tableId, String fieldName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_ID", (Object)tableId);
        queryWrapper.eq((Object)"CODE_", (Object)fieldName);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateFields(List<BizShareTableField> fields) throws Exception {
        if (fields.size() == 0) {
            throw new ApplicationException("\u6ca1\u6709\u4fee\u6539\u7684\u5b57\u6bb5");
        }
        String tableId = fields.get(0).getTableId();
        BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)tableId));
        List disFieldList = fields.stream().map(p -> p.getFieldCode()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < fields.size()) {
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        String tableName = table.getTableCode();
        String dbAlias = table.getDbAlias();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)dbAlias);
        for (BizShareTableField field : fields) {
            field.setIsCreate("1");
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            field.setDecimalLen(decimalLen);
            field.setFieldCode(field.getCode());
            if (StringUtil.isEmpty((String)field.getId())) {
                if (field.getSn() == null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("TABLE_ID_", tableId);
                    field.setSn(this.getNextSequence(map));
                }
                field.setResourceCode(fields.get(0).getResourceCode());
                field.setResourceName(fields.get(0).getResourceName());
                String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
                field.setFlSql(fieldSq);
                template.execute(fieldSq);
                continue;
            }
            if (!this.fieldEquals(field)) continue;
            BizShareTableField oldField = (BizShareTableField)((Object)this.getById((Serializable)((Object)field.getId())));
            if (field.getFieldCode().equals(oldField.getFieldCode())) continue;
            String fieldSq = "ALTER TABLE `" + tableName + "` CHANGE `" + oldField.getFieldCode() + "`  `" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " DEFAULT NULL COMMENT '" + field.getDesc() + "' ";
            template.execute(fieldSq);
        }
        this.saveOrUpdateBatch(fields);
        String createSql = this.tableManager.queryTableSql(tableId);
        table.setCreateTableSql(createSql);
        table.setFieldTotal(fields.size());
        this.tableManager.updateById((Object)table);
    }

    public boolean fieldEquals(BizShareTableField field) {
        BizShareTableField oldField = (BizShareTableField)((Object)this.getById((Serializable)((Object)field.getId())));
        return !field.getFieldCode().equals(oldField.getFieldCode()) || !field.getDesc().equals(oldField.getDesc());
    }
}

