/** 0:电话, 1:短信, 2:应用内 */
export declare type AlertType = 0 | 1 | 2;
export interface CreateDingV2Params {
    /**
     * 用户 ID
     */
    users: string[];
    /**
     * 组织 ID
     */
    corpId?: string;
    /**
     * 发送 Ding 类型
     */
    alertType: AlertType;
    /**
     * Ding 消息正文内容
     */
    text: string;
    /**
     * Ding 消息展示类型
     * - 0 text 文本
     * - 1 image 图片
     * - 2 link 链接卡片
     */
    type?: 0 | 1 | 2;
    /**
     * 默认 type = 0 为文本，不用传递任何内容
     * 当 type = 1 时为图片，传入 string[] 表示图片列表
     * 当 type = 2 时为链接，传入 { title: string, url: string, image: string, text: string, bizName: string, urlPc: string } 表示链接内容
     */
    attachment?: {
        images: string[];
    } | {
        /**
         * 链接卡片标题
         */
        title: string;
        /**
         * 链接卡片默认 url
         */
        url: string;
        /**
         * 连接卡片 PC 端展示 url
         * @optional
         */
        urlPc?: string;
        /**
         * 链接卡片上图标 icon 图片地址
         */
        image: string;
        /**
         * 链接卡片上的说明文字
         */
        text: string;
        /**
         * 发送 Ding 链接卡片的业务名称
         */
        bizName: string;
    };
    /**
     * 是否禁用选人，默认 false
     */
    disableSelectUser?: boolean;
    /**
    *  是否禁止编辑文本内容，默认 false
    */
    disableEditText?: boolean;
}
declare function createDingV2(params: CreateDingV2Params): Promise<{
    success: boolean;
}>;
declare namespace createDingV2 {
    var version: {
        android: string;
        ios: string;
        pc: string;
    };
}
export default createDingV2;
