package com.artfess.sysConfig.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.sysConfig.persistence.model.SysMenu;
import com.artfess.sysConfig.persistence.model.SysRoleAuth;
import com.artfess.sysConfig.persistence.model.SysSwiftMenu;
import com.artfess.sysConfig.persistence.param.SysRoleAuthParam;

import java.util.HashMap;
import java.util.List;

/**
 * 
 * <pre> 
 * 描述：用户自定义菜单 处理接口
 * 构建组：x6
 * 作者:liyg
 * 邮箱:liygui@jee-soft.cn
 * 日期:2018-06-29 14:27:46
 * 版权：广州宏天软件有限公司
 * </pre>
 */
public interface SysSwiftMenuManager extends BaseManager<SysSwiftMenu>{
    /**
    * @Description: 保存登录人的自定义菜单
    * @param menuAlias  菜单别名
    * @Return: java.lang.String
    * @Author: chens
    * @Date: 2023/12/4 15:15
    */
    String insertSwiftMenus(String menuAlias);

    /**
    * @Description: 取消登录人的自定义菜单
    * @param menuAlias  菜单别名
    * @Return: boolean
    * @Author: chens
    * @Date: 2023/12/4 15:15
    */
    Integer removeSwiftMenus(String menuAlias);

    /**
     * @Description: 获取登录人的自定义菜单
     * @param userId  用户ID
     * @Return: boolean
     * @Author: chens
     * @Date: 2023/12/4 15:15
     */
    List<SysMenu> getSwiftMenus(String userId);

}
