package com.artfess.ljzc.business.vo;

import com.artfess.base.model.Tree;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目楼栋树
 */
@Data
@ApiModel(description = "项目楼栋树 ")
public class ProjectTreeVo implements Tree {


    /**
     * 主键
     */
    @ApiModelProperty(name = "id", notes = "id")
    protected String id;

    /**
     * name_
     */
    @ApiModelProperty(name = "name", notes = "名称")
    protected String name;

    /**
     * prent_id_
     */
    @ApiModelProperty(name = "parentId", notes = "父节点id")
    protected String parentId;

    /**
     * code_
     */
    @ApiModelProperty(name = "code", notes = "编码")
    protected String code;

    /**
     * 数据类型（project:项目,building：楼栋）
     */
    @ApiModelProperty(name = "type", notes = "数据类型（project:项目,building：楼栋）")
    protected String type;

    /**
     * 是否有子节点   否0  是1
     */
    @ApiModelProperty(name = "isIsParent", notes = "是否有子节点   否0  是1")
    protected boolean isIsParent;


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    protected List<ProjectTreeVo> children = new ArrayList<ProjectTreeVo>();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setIsParent(String isParent) {

    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

}
