import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '战略供应商',
            prop: 'zl',
            type: 'input',
            value: ''
        },
        {
            title: '重要供应商',
            prop: 'zl',
            type: 'input',
            value: ''
        },
        {
            title: '一般供应商',
            prop: 'yl',
            type: 'input',
            value: ''
        },
        {
            title: 'A类供应商',
            prop: 'al',
            type: 'input',
            value: ''
        },
        {
            title: 'B类供应商',
            prop: 'bl',
            type: 'input',
            value: ''
        },
        {
            title: 'C类供应商',
            prop: 'cl',
            type: 'input',
            value: ''
        },
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '企业名称',
            prop: 'companyCode',
            type: 'input',
            span: 4,
            value: ''
        }
    ]
    const columnsList: COption[] = [
        {
            title: '企业名称',
            prop: 'enterpriseName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '战略供应商',
            prop: 'zl',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '重要供应商',
            prop: 'zy',
            minWidth: 160,
            sortable: true
        },
        {
            title: '一般供应商',
            prop: 'yb',
            minWidth: 120,
            sortable: true
        },
        {
            title: 'A类供应商',
            prop: 'al',
            minWidth: 120,
            sortable: true
        },
        {
            title: 'B类供应商',
            prop: 'bl',
            minWidth: 120,
            sortable: true
        },
        {
            title: 'C类供应商',
            prop: 'cl',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
