import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '评审要求',
            prop: 'desc',
            type: 'input',
            value: ''
        },
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '编码',
            prop: 'code',
            type: 'input',
            value: '',
            span: 4
        },
        {
            title: '名称',
            prop: 'name',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '启用/禁用',
            prop: 'status',
            type: 'select',
            options: [
                { name: '禁用', value: '0' },
                { name: '启用', value: '1' }
            ],
            value: '',
            span: 4
        },
        {
            title: '创建时间',
            prop: 'createTime',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '编码',
            prop: 'code',
            minWidth: 160,
            sortable: true
        },
        {
            title: '名称',
            prop: 'name',
            minWidth: 160,
            sortable: true
        },
        {
            title: '供应商分类',
            prop: 'supplierCategoryName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '评审要求',
            prop: 'desc',
            minWidth: 300,
            sortable: true,
            render: true
        },
        {
            title: '总分',
            prop: 'totalScore',
            minWidth: 120,
            sortable: true
        },
        {
            title: '备注',
            prop: 'remarks',
            minWidth: 120,
            sortable: true
        },
        {
            title: '启用/禁用',
            prop: 'status',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '创建时间',
            prop: 'createTime',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
