import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluationConfiguration/v1/query`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 查询供应商分级
export function dataSupplierClass(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('bizSupplierGradingConfiguration/v1/query',data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 获取考核类别列表
export function getAppraisal(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('/bizSupplierAssessmentIndicatorType/v1/query',data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 表格新增
export function dataAdd(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluationConfiguration/v1/saveModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格详情
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierPerformanceEvaluationConfiguration/v1/getModel/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

        
// 表格修改
export function dataUpdate(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluationConfiguration/v1/updateModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 表格修改状态
export function dataStatus(id: string, status: string) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluationConfiguration/v1/updateByStatus?id=${id}&status=${status}`,)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格删除
export function dataDelete(ids: string) {
    return new Promise((resolve, reject) => {
        request
            .delete(`/bizSupplierPerformanceEvaluationConfiguration/v1/?ids=${ids}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 查询未绑定供应商
export function dataUnBindSupplier(configId: string,categoryId: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierPerformanceEvaluationConfiguration/v1/getSuppliers?configId=${configId}&categoryId=${categoryId}`)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 保存分配供应商 
export function dataDistribution(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('/bizSupplierPerformanceEvaluationConfiguration/v1/bindUser', data)
            .then((res) => resolve(res?.data || {}))    
            .catch((err) => reject(err))
    })
}
// 查询已绑定供应商
export function dataBindSupplier(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('/bizSupplierPerformanceEvaluationConfigurationUser/v1/', data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
