import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseAccess/v1/queryPage`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格回显
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/getInfo/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格删除
export function dataDelete(ids: string) {
    return new Promise((resolve, reject) => {
        request
            .delete(`/bizSupplierEnterpriseAccess/v1/?ids=${ids}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 获取申请左边菜单列表
export function getFillingProgress(categoryld: string, id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/getMenu?categoryId=${categoryld}&id=${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 获取企业列表
export function getOwnerEnterprise() {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/getOwnerEnterprise`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 获取供应商列表
export function getSupplier(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizEnterprise/v1/query`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格保存-准入申请
export function dataSubmit(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseAccess/v1/saveOrUpdateEnterpriseAccess`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格保存-其他数据
export function dataSubmitOtherInfo(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseAccess/v1/saveOrUpdateOtherInfo`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

//获取资质类型列表
export function getQualificationType(categoryId: string, type: string) {
    return new Promise((resolve, reject) => {
        request
            .get(
                `/bizSupplierEnterpriseAccess/v1/getQualification?categoryId=${categoryId}&type=${type}`
            )
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

//提交审核
export function dataAudit(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/submit?id=${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
