/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.task.userassign.plugin;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.artfess.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.plugin.core.runtime.BaseUserAssignPlugin;
import com.artfess.bpm.plugin.task.userassign.def.UserAssignPluginDef;
import com.artfess.bpm.plugin.task.userassign.plugin.UserQueryPlugin;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;

public class UserAssignPlugin
extends BaseUserAssignPlugin {
    @Override
    public void executeExt(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef) throws Exception {
        BpmDelegateTask bpmDelegateTask = pluginSession.getBpmDelegateTask();
        String parentFlowKey = (String)bpmDelegateTask.getSupperVariable("flowKey_");
        UserAssignPluginDef assignPluginDef = new UserAssignPluginDef();
        try {
            BeanUtils.copyNotNullProperties((Object)assignPluginDef, (Object)((UserAssignPluginDef)pluginDef));
        }
        catch (Exception e) {
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        this.handelRules(assignPluginDef, parentFlowKey);
        BpmUserCalcPluginSession bpmUserCalcPluginSession = this.getBpmPluginSessionFactory().buildBpmUserCalcPluginSession(bpmDelegateTask);
        UserQueryPlugin userQueryPlugin = (UserQueryPlugin)AppUtil.getBean(UserQueryPlugin.class);
        List<BpmIdentity> bpmIdentities = userQueryPlugin.execute(bpmUserCalcPluginSession, assignPluginDef);
        if (BeanUtils.isNotEmpty(bpmIdentities)) {
            bpmDelegateTask.addExecutors(bpmIdentities);
        }
    }

    private void handelRules(UserAssignPluginDef assignPluginDef, String parentFlowKey) {
        List<UserAssignRule> rules;
        if (StringUtil.isEmpty((String)parentFlowKey)) {
            parentFlowKey = "local_";
        }
        if (BeanUtils.isEmpty(rules = assignPluginDef.getRuleList())) {
            return;
        }
        List<UserAssignRule> assignRules = this.getAssignRules(rules, parentFlowKey);
        if (!"local_".equals(parentFlowKey) && BeanUtils.isEmpty(assignRules)) {
            assignRules = this.getAssignRules(rules, "local_");
        }
        assignPluginDef.setRuleList(assignRules);
    }

    private List<UserAssignRule> getAssignRules(List<UserAssignRule> rules, String key) {
        ArrayList<UserAssignRule> assignRules = new ArrayList<UserAssignRule>();
        for (UserAssignRule rule : rules) {
            String parentKey = rule.getParentFlowKey();
            if (parentKey.equals("local_")) {
                rule.setGroupNo(rule.getGroupNo() + 100);
                assignRules.add(rule);
                continue;
            }
            if (!parentKey.equals(key)) continue;
            assignRules.add(rule);
        }
        return assignRules;
    }
}

