/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.persistence.manager.impl;

import com.artfess.application.model.MessageRead;
import com.artfess.application.persistence.dao.MessageReadDao;
import com.artfess.application.persistence.manager.MessageReadManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="messageReadManager")
public class MessageReadManagerImpl
extends BaseManagerImpl<MessageReadDao, MessageRead>
implements MessageReadManager {
    @Override
    public void addMessageRead(String msgId, IUser sysUser) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", sysUser.getUserId());
        params.put("msgId", msgId);
        MessageRead msgRead = ((MessageReadDao)this.baseMapper).getReadByUser(params);
        if (msgRead == null) {
            MessageRead messageRead = new MessageRead();
            messageRead.setId(UniqueIdUtil.getSuid());
            messageRead.setMsgId(msgId);
            messageRead.setReceiverId(sysUser.getUserId());
            messageRead.setReceiver(sysUser.getFullname());
            messageRead.setReceiverTime(LocalDateTime.now());
            this.create((Model)messageRead);
        }
    }

    @Override
    public List<MessageRead> getByMessageId(String messageId) {
        return ((MessageReadDao)this.baseMapper).getByMessageId(messageId);
    }
}

