package com.artfess.dataShare.util;

import com.artfess.base.feign.FormFeignService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTableField;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.jdbc.core.JdbcTemplate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 同步表结构到宏天的表
 */
public class SyncTableUtil {

    public static Map<String,Object> initDefMap(String moduleId,String code, String desc,String dbAlias, String categoryId,String  categoryName){
        Map<String,Object> boDef=new HashMap<>();
        boDef.put("createBy",null);
        boDef.put("createTime",null);
        boDef.put("updateBy",null);
        boDef.put("updateTime",null);
        boDef.put("id",moduleId);
        boDef.put("alias",code);
        boDef.put("description",desc);
        boDef.put("supportDb", true);
        boDef.put("categoryId",categoryId);
        boDef.put("categoryName",categoryName);
        boDef.put("status","normal");
        boDef.put("dbAlias",dbAlias);
        boDef.put("deployed",true);
        boDef.put("rev",14);
        boDef.put("pkVal",moduleId);
        return boDef;
    }

    public static Map<String,Object> initTableMap(String tableId,String tableName,String code, String desc,String dbAlias,boolean createdTable){
        //code=code.replace("w_","");
        Map<String,Object> boEnt=new HashMap<>();
        boEnt.put("id",tableId);
        boEnt.put("name",tableName);
        boEnt.put("desc",desc);
        boEnt.put("packageId","");
        boEnt.put("dsName",null);
        boEnt.put("tableName",tableName);
        boEnt.put("external",false);
        boEnt.put("status","actived");
        boEnt.put("pk","id_");
        boEnt.put("fk","ref_id_");
        boEnt.put("pk_type",null);
        boEnt.put("type","main");
        boEnt.put("tableNameNoPrefix",null);
        boEnt.put("dbAlias",dbAlias);
        boEnt.put("show","主实体");
        boEnt.put("relation","main");
        boEnt.put("canEditTable",false);
        boEnt.put("comment",desc);
        boEnt.put("createdTable",1);
        boEnt.put("isCreateTable",1);
        //boEnt.put("external",true);
        boEnt.put("pkKey","id_");
        boEnt.put("fieldPrefix","");
        boEnt.put("pkNumber",false);
        boEnt.put("pkVal",tableId);
        return boEnt;
    }

    public static Map<String,String> sendFormFeignService(JdbcTemplate localJdbcTemplate,Map<String, Object> boDef) throws IOException{
        JsonNode objectNode=JsonUtil.toJsonNode(boDef);
        List<ObjectNode> objectNodes=new ArrayList<>();
        objectNodes.add((ObjectNode)objectNode);

        //objectNodes.add(objectNode);
        FormFeignService formFeignService= AppUtil.getBean(FormFeignService.class);
        Object result=formFeignService.importBoDefNew(objectNodes);
        List<Map<String,Object>> resultMaps=(List<Map<String,Object>>)result;
        String defId=resultMaps.get(0).get("id").toString();
        //返回结果里面没有表ID，所以这里查询一次
        String queryDefSql="select ref_ent_id_ from form_bo_ent_relation where bo_defid_=?";
        String odsTableId=localJdbcTemplate.queryForObject(queryDefSql,new Object[]{defId},String.class);
        System.out.println(result);
        //BoDef boDef = new BoDef();
        //BoEnt boEnt = new BoEnt();
        Map<String,String> map=new HashMap<>();
        map.put("defId",defId);
        map.put("tableId",odsTableId);
        return map;
    }

    public static Map<String,String> createMouldAndTable(JdbcTemplate localJdbcTemplate, JdbcTemplate jdbcTemplate, String tableId, String moduleId, String tableName, String code, String desc, String dbAlias, List<BizClusterTableField> fieldList, String categoryId, String  categoryName) throws IOException {
        //封装json  模型
        Map<String,Object> boDef=initDefMap(moduleId,code,desc,dbAlias,categoryId,categoryName);
        //表
        Map<String,Object> boEnt=initTableMap(tableId,tableName,code,desc,dbAlias,false);

        List<Map<String,Object>> fieldMapList=new ArrayList<>();
        //封装字段信息
        for(BizClusterTableField field : fieldList){
            if("ID_".equalsIgnoreCase(field.getFieldName())){
                continue;
            }
            Map<String,Object> fieldMap=new HashMap<>();
            initField(tableId, fieldMap, field.getId(), field.getFieldName(), field.getDesc(), field.getDataType(), field.getDefaultValue(), field.getFormat(), field.getAttrLength(), field.getDecimalLen(), field.getSn(), field.getFieldName());//"F_"+field.getFieldName());
            /*fieldMap.put("id",field.getId());
            fieldMap.put("entId",tableId);
            fieldMap.put("name",field.getFieldName());
            fieldMap.put("desc",field.getDesc());
            fieldMap.put("dataType",getColumnType(field.getDataType()));
            fieldMap.put("defaultValue",field.getDefaultValue());
            fieldMap.put("format",field.getFormat());
            fieldMap.put("isRequired",0);
            fieldMap.put("attrLength",field.getAttrLength());
            fieldMap.put("decimalLen", field.getDecimalLen());
            fieldMap.put("sn",field.getSn());
            fieldMap.put("fieldName","F_"+field.getFieldName());
            fieldMap.put("status", null);
            fieldMap.put("index", 6);
            fieldMap.put("fcolumnType", null);
            fieldMap.put("isPk", false);
            fieldMap.put("isNull", false);
            fieldMap.put("tableName","");
            fieldMap.put("comment",field.getDesc());
            fieldMap.put("charLen", field.getAttrLength());
            fieldMap.put("columnType",getColumnType(field.getDataType()));
            fieldMap.put("intLen",field.getAttrLength());
            fieldMap.put("pkVal",field.getId());*/
            fieldMapList.add(fieldMap);
        }

        boEnt.put("attributeList",fieldMapList);
        boEnt.put("childEnts",new ArrayList<>());
        List<Map<String,Object>> boEnts=new ArrayList<>();
        boEnts.add(boEnt);
        boDef.put("boEnt",boEnt);
        boDef.put("ents",boEnts);
        System.out.println(boDef);

        /*JsonNode objectNode=JsonUtil.toJsonNode(boDef);
        List<ObjectNode> objectNodes=new ArrayList<>();
        objectNodes.add((ObjectNode)objectNode);

        //objectNodes.add(objectNode);
        FormFeignService formFeignService= AppUtil.getBean(FormFeignService.class);
        Object result=formFeignService.importBoDefNew(objectNodes);
        List<Map<String,Object>> resultMaps=(List<Map<String,Object>>)result;
        String defId=resultMaps.get(0).get("id").toString();
        //返回结果里面没有表ID，所以这里查询一次
        String queryDefSql="select ref_ent_id_ from form_bo_ent_relation where bo_defid_=?";
        String odsTableId=jdbcTemplate.queryForObject(queryDefSql,new Object[]{defId},String.class);
        System.out.println(result);
        //BoDef boDef = new BoDef();
        //BoEnt boEnt = new BoEnt();
        Map<String,String> map=new HashMap<>();
        map.put("defId",defId);
        map.put("tableId",odsTableId);*/
        return sendFormFeignService(localJdbcTemplate,boDef);
    }

    public static Map<String,String> createDwMouldAndTable(JdbcTemplate localJdbcTemplate,JdbcTemplate jdbcTemplate,String tableId, String moduleId, String name, String code, String desc, String dbAlias, List<BizDwdCatalogsTableField> fieldList,String categoryId,String  categoryName) throws IOException {
        //封装json  模型
        Map<String,Object> boDef=initDefMap(moduleId,code,desc,dbAlias,categoryId,categoryName);
        //表
        Map<String,Object> boEnt=initTableMap(tableId,"dwd_"+name,code,desc,dbAlias,true);

        List<Map<String,Object>> fieldMapList=new ArrayList<>();
        //封装字段信息
        for(BizDwdCatalogsTableField field : fieldList){
            if("ID_".equalsIgnoreCase(field.getName())){
                continue;
            }
            Map<String,Object> fieldMap=new HashMap<>();
            initField(tableId, fieldMap, field.getId(), field.getFieldCode(), field.getDesc(), field.getDataType(), field.getDefaultValue(), field.getFormat(), field.getAttrLength(), field.getDecimalLen(), field.getSn(), field.getFieldCode());//"F_"+field.getFieldCode());
            fieldMapList.add(fieldMap);
        }

        boEnt.put("attributeList",fieldMapList);
        boEnt.put("childEnts",new ArrayList<>());
        List<Map<String,Object>> boEnts=new ArrayList<>();
        boEnts.add(boEnt);
        boDef.put("boEnt",boEnt);
        boDef.put("ents",boEnts);
        System.out.println(boDef);

        /*JsonNode objectNode= JsonUtil.toJsonNode(boDef);
        List<ObjectNode> objectNodes=new ArrayList<>();
        objectNodes.add((ObjectNode)objectNode);

        FormFeignService formFeignService= AppUtil.getBean(FormFeignService.class);
        Object result=formFeignService.importBoDefNew(objectNodes);
        List<Map<String,Object>> resultMaps=(List<Map<String,Object>>)result;
        String defId=resultMaps.get(0).get("id").toString();
        //返回结果里面没有表ID，所以这里查询一次
        String queryDefSql="select ref_ent_id_ from form_bo_ent_relation where bo_defid_=?";
        String odsTableId=jdbcTemplate.queryForObject(queryDefSql,new Object[]{defId},String.class);
        System.out.println(result);

        Map<String,String> map=new HashMap<>();
        map.put("defId",defId);
        map.put("tableId",odsTableId);
        return map;*/
        return sendFormFeignServiceNotCreateTable(localJdbcTemplate,boDef);
    }

    public static Map<String,String> createOdsMouldAndTable(JdbcTemplate localJdbcTemplate,JdbcTemplate jdbcTemplate,String tableId, String moduleId, String name, String code, String desc, String dbAlias, List<BizOdsField> fieldList, String categoryId,String  categoryName) throws IOException {
        //BizOdsCatalogs module= this.odsCatalogsManager.getById(catalogId);
        //封装json  模型
        Map<String,Object> boDef=initDefMap(moduleId,code,desc,dbAlias,categoryId,categoryName);
        //表
        Map<String,Object> boEnt=initTableMap(tableId,"ods_"+name,code,desc,dbAlias,true);

        List<Map<String,Object>> fieldMapList=new ArrayList<>();
        //封装字段信息
        for(BizOdsField field : fieldList){
            if("ID_".equalsIgnoreCase(field.getFieldName())){
                continue;
            }
            Map<String,Object> fieldMap=new HashMap<>();
            initField(tableId, fieldMap, field.getId(), field.getFieldName(), field.getDesc(), field.getDataType(), field.getDefaultValue(), field.getFormat(), field.getAttrLength(), field.getDecimalLen(), field.getSn(), field.getFieldName());
            fieldMapList.add(fieldMap);
        }

        boEnt.put("attributeList",fieldMapList);
        boEnt.put("childEnts",new ArrayList<>());
        List<Map<String,Object>> boEnts=new ArrayList<>();
        boEnts.add(boEnt);
        boDef.put("boEnt",boEnt);
        boDef.put("ents",boEnts);
        System.out.println(boDef);

        /*JsonNode objectNode= JsonUtil.toJsonNode(boDef);
        List<ObjectNode> objectNodes=new ArrayList<>();
        objectNodes.add((ObjectNode)objectNode);

        //objectNodes.add(objectNode);
        FormFeignService formFeignService= AppUtil.getBean(FormFeignService.class);
        Object result=formFeignService.importBoDefNew(objectNodes);
        List<Map<String,Object>> resultMaps=(List<Map<String,Object>>)result;
        String defId=resultMaps.get(0).get("id").toString();
        //返回结果里面没有表ID，所以这里查询一次
        String queryDefSql="select ref_ent_id_ from form_bo_ent_relation where bo_defid_=?";
        String odsTableId=jdbcTemplate.queryForObject(queryDefSql,new Object[]{defId},String.class);
        System.out.println(result);
        //BoDef boDef = new BoDef();
        //BoEnt boEnt = new BoEnt();
        Map<String,String> map=new HashMap<>();
        map.put("defId",defId);
        map.put("tableId",odsTableId);
        return map;*/
        return sendFormFeignServiceNotCreateTable(localJdbcTemplate,boDef);
    }

    public static Map<String,String> sendFormFeignServiceNotCreateTable(JdbcTemplate localJdbcTemplate,Map<String, Object> boDef) throws IOException{
        JsonNode objectNode=JsonUtil.toJsonNode(boDef);
        List<ObjectNode> objectNodes=new ArrayList<>();
        objectNodes.add((ObjectNode)objectNode);

        //objectNodes.add(objectNode);
        FormFeignService formFeignService= AppUtil.getBean(FormFeignService.class);
        Object result=formFeignService.importBoDefNewNotCreateTable(objectNodes);
        List<Map<String,Object>> resultMaps=(List<Map<String,Object>>)result;
        String defId=resultMaps.get(0).get("id").toString();
        //返回结果里面没有表ID，所以这里查询一次
        String queryDefSql="select ref_ent_id_ from form_bo_ent_relation where bo_defid_=?";
        String odsTableId=localJdbcTemplate.queryForObject(queryDefSql,new Object[]{defId},String.class);
        System.out.println(result);
        //BoDef boDef = new BoDef();
        //BoEnt boEnt = new BoEnt();
        Map<String,String> map=new HashMap<>();
        map.put("defId",defId);
        map.put("tableId",odsTableId);
        return map;
    }

    private static void initField(String tableId, Map<String, Object> fieldMap, String id, String fieldName, String desc2, String dataType, String defaultValue, String format, Integer attrLength, Integer decimalLen, Integer sn, String fieldName2) {
        fieldMap.put("id", id);
        fieldMap.put("entId", tableId);
        fieldMap.put("name", fieldName);
        fieldMap.put("desc", desc2);
        fieldMap.put("dataType", dataType);
        //fieldMap.put("dataType", FieldUtil.getColumnType(dataType));
        fieldMap.put("defaultValue", defaultValue);
        fieldMap.put("format", format);
        fieldMap.put("isRequired", 0);
        fieldMap.put("attrLength", attrLength);
        fieldMap.put("decimalLen", decimalLen);
        fieldMap.put("sn", sn);
        fieldMap.put("fieldName", fieldName2);
        fieldMap.put("status", null);
        fieldMap.put("index", 6);
        fieldMap.put("fcolumnType", null);
        fieldMap.put("isPk", false);
        fieldMap.put("isNull", false);
        fieldMap.put("tableName", "");
        fieldMap.put("comment", desc2);
        fieldMap.put("charLen", attrLength);
        //fieldMap.put("columnType", FieldUtil.getColumnType(dataType));
        fieldMap.put("columnType", dataType);
        fieldMap.put("intLen", attrLength);
        fieldMap.put("pkVal", id);
    }

    public static String getColumnType(String columnType) {
        if ("字符串".equalsIgnoreCase(columnType)) {
            return "varchar";
        } else if ("小数".equalsIgnoreCase(columnType)) {
            return "decimal";
        } else if ("日期".equalsIgnoreCase(columnType)) {
            return "date";
        }else if ("数值".equals(columnType)||"数字".equals(columnType)) {
            return "number";
        } else if ("文本".equalsIgnoreCase(columnType)) {
            return "text";
        } else {
            return "";
        }
    }
}
