package com.artfess.dataShare.scheduler.dao;

import com.artfess.dataShare.scheduler.model.BizSchedulerJob;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 定时任务作业  ---  配置表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-16
 */
public interface BizSchedulerJobDao extends BaseMapper<BizSchedulerJob> {
    /**
     * @Description: 分页查询汇集采集任务
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizSchedulerJob> queryCollectPage(IPage<BizSchedulerJob> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizSchedulerJob> convert2Wrapper);

    /**
     * @Description: 分页查询共享采集任务
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizSchedulerJob> querySharePage(IPage<BizSchedulerJob> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizSchedulerJob> convert2Wrapper);

    /**
     * @Description: 分页查询数据明细层清理任务
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizSchedulerJob> queryDwdPage(IPage<BizSchedulerJob> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizSchedulerJob> convert2Wrapper);
    /**
     * @Description: 分页查询数据应用层计算任务
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizSchedulerJob> queryAppPage(IPage<BizSchedulerJob> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizSchedulerJob> convert2Wrapper);
    /**
     * @Description: 分页查询
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizSchedulerJob> queryPage(IPage<BizSchedulerJob> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizSchedulerJob> convert2Wrapper);
}
