package com.artfess.dataShare.role.manager.impl;

import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsManager;
import com.artfess.dataShare.dataResource.dw.manager.BizDwCatalogsManager;
import com.artfess.dataShare.dataResource.dw.model.BizDwCatalogs;
import com.artfess.dataShare.role.model.BizRoleCatalogs;
import com.artfess.dataShare.role.dao.BizRoleCatalogsDao;
import com.artfess.dataShare.role.manager.BizRoleCatalogsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.dataShare.role.vo.CatalogsVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * 角色数据目录授权表（角色关联人员的目录分类） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-25
 */
@Service
public class BizRoleCatalogsManagerImpl extends BaseManagerImpl<BizRoleCatalogsDao, BizRoleCatalogs> implements BizRoleCatalogsManager {

/*    @Resource
    BizDwCatalogsManager dwCatalogsManager;

    @Resource
    BizAppCatalogsManager appCatalogsManager;*/

    @Resource
    JdbcTemplate jdbcTemplate;

    public List<CatalogsVo> queryDwCatalogsId(String dataType){
        List<Map<String,Object>> roleMaps=ContextUtil.getCurrentUserRoles();
        List<String> roleIds=roleMaps.stream().map(p->p.get("roleId").toString()).collect(Collectors.toList());
        String ids=roleIds.stream().collect(Collectors.joining("','"));
        if("DWD".equalsIgnoreCase(dataType)){
            String querySql="select t1.id_ id,t1.name_ name,t1.code_ code,t.id_ join_id,'DWD' type from BIZ_ROLE_CATALOGS t \n" +
                    " INNER JOIN biz_dwd_catalogs t1 on t.DW_CATALOGS_ID_=t1.ID_\n" +
                    " where DATA_TYPE_='DWD' and t1.IS_DELE_=0 AND ROLE_ID_ in ('"+ids+"')";
            List<CatalogsVo> list=jdbcTemplate.query(querySql, new BeanPropertyRowMapper<CatalogsVo>(CatalogsVo.class));
            return list;
        }else if("APP".equalsIgnoreCase(dataType)){
            String querySql="select t1.id_ id,t1.name_ name,t1.code_ code,t.id_ join_id,'APP' type from BIZ_ROLE_CATALOGS t \n" +
                    " INNER JOIN biz_app_catalogs t1 on t.DW_CATALOGS_ID_=t1.ID_\n" +
                    " where DATA_TYPE_='APP' and t1.IS_DELE_=0 AND ROLE_ID_ in ('"+ids+"')";
            List<CatalogsVo> list=jdbcTemplate.query(querySql, new BeanPropertyRowMapper<CatalogsVo>(CatalogsVo.class));
            return list;
        }
        return null;
    }

    public List<CatalogsVo> queryDwCatalogByRoleId(String roleId){
        String querySql="select t1.id_ id,t1.name_ name,t1.code_ code,t.id_ join_id,'DWD' type from BIZ_ROLE_CATALOGS t \n" +
                " INNER JOIN biz_dwd_catalogs t1 on t.DW_CATALOGS_ID_=t1.ID_\n" +
                " where DATA_TYPE_='DWD' and t1.IS_DELE_=0 AND t.ROLE_ID_ = ?"+
                " union"+
                " select t1.id_ id,t1.name_ name,t1.code_ code,t.id_ join_id,'APP' type from BIZ_ROLE_CATALOGS t \n" +
                " INNER JOIN biz_app_catalogs t1 on t.DW_CATALOGS_ID_=t1.ID_\n" +
                " where DATA_TYPE_='APP' and t1.IS_DELE_=0 AND t.ROLE_ID_ = ?";
        List<CatalogsVo> list=jdbcTemplate.query(querySql,new Object[]{roleId,roleId}, new BeanPropertyRowMapper<CatalogsVo>(CatalogsVo.class));
        return list;
    }
}
