package com.artfess.dataShare.dataShare.vo;

import com.artfess.base.util.BeanUtils;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.dataShare.dataResource.ods.vo.BizOdsFieldVo;
import com.artfess.dataShare.dataShare.model.BizShareTableField;
import com.artfess.poi.annotation.Excel;
import lombok.Data;

import java.lang.reflect.InvocationTargetException;

@Data
public class ShareTableFieldVo {

    @Excel(name ="*字段类别",readConverterExp = "1=管理字段,2=业务字段")
    private String fieldType;

    @Excel(name ="*字段中文名")
    private String name;

    @Excel(name ="*字段英文名")
    private String code;

    @Excel(name ="*字段描述（字段备注释义）")
    private String desc;

    @Excel(name ="*数据类型",readConverterExp = "varchar=字符串,number=数字,date=日期,text=大文本")
    private String dataType;

    @Excel(name ="数据长度")
    private Integer attrLength;

    @Excel(name ="数据精度")
    private Integer decimalLen;

    @Excel(name ="字段默认值")
    private String defaultValue;

    @Excel(name ="是否主键",readConverterExp = "0=否,1=是")
    private String isPk;

    @Excel(name ="是否存储加密",readConverterExp = "0=否,1=是")
    private String isEncrypt;

    @Excel(name ="是否脱敏",readConverterExp = "0=否,1=是")
    private String isDesensitize;

    @Excel(name ="序号")
    private Integer sn;

    public static BizShareTableField parse(ShareTableFieldVo roleVo){
        BizShareTableField vo = new BizShareTableField();
        try {
            BeanUtils.copyNotNullProperties(vo,roleVo);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return vo;
    }
}
